<?php

namespace App\Controllers;

include_once 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use \PhpOffice\PhpSpreadsheet\Reader\IReader;
class FormatoCarga extends BaseController
{

    public function index(){    	
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("formatocarga/formatocarga");
        echo view("layouts/footer");
    }
    
    public function enviar_conciliacion($data,$id){
        $body = json_encode($data);
        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => array(
                    'Content-type: application/json',
                    'Authorization:rapidito-prod;7g::H]d<e%USiL1QTW',
                ),
                'content' => $body,
                'ignore_errors' => true,
            )
        );

        $contexto = stream_context_create($opciones);
        //$resultado = file_get_contents('https://int.api.megaprofer.com/api/conciliation/sendAccountingMove', false, $contexto);       API PRUEBA
        $resultado = file_get_contents('https://api.megaprofer.com/api/conciliation/sendAccountingMove', false, $contexto);
        $resultado=json_decode($resultado,true); 

        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }
    }

    public function agregar_referencia_contable($pac_id,$pac_referencia_contable){
        $datos_post = http_build_query(
            array(
                "pac_referencia_contable"=>$pac_referencia_contable,                
                "pac_id"=>$pac_id,      
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'pagoreferenciacontable', false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }


    }
    
    public function tabla()
    {
        try {
        $session = \Config\Services::session();
        $nombre_archivo=null;
        if(!empty($_FILES["archivoseleccionado"]["name"])){
            $nombre_archivo = $_FILES["archivoseleccionado"]["name"];            
        }   
        $banco=$_POST["banco"];
        
        if($nombre_archivo!=null ){            
            $url =$this->url_api_conciliacion.'banco';
            $respuesta = file_get_contents($url);           
            $respuesta=json_decode($respuesta,true);
            $respuesta=$respuesta['data'];

            $path = $_FILES["archivoseleccionado"]["tmp_name"];
            $extension = pathinfo($nombre_archivo, PATHINFO_EXTENSION);
            //print_r($path);
            if($banco!='bancoguayaquil'){
                if($extension=='xlsx'){
                $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                $reader->setReadDataOnly(true);
                $spreadsheet = $reader->load($path);
                $sheet = $spreadsheet->getActiveSheet();}
                else{
                    $session->setFlashdata('mensaje_malo', 'Error al seleccionar el banco pagador');
                    return redirect()->to(base_url('FormatoCarga')); 
                }
            }
                
            
            else
            {
                if($extension=='txt'){
                $arrayArchivo = file($path, FILE_IGNORE_NEW_LINES);
                }
                else{
                    $session->setFlashdata('mensaje_malo', 'Error al seleccionar el banco pagador');
                    return redirect()->to(base_url('FormatoCarga')); 
                }
            }
            $total_descuento_comision=0;
            $total_monto_depositado=0;
            $total_total_pagar=0;
            $total_retencion_iva=0;
            $total_retencion_fuente=0;

            $data=[];
            $lectura_total='Lectura de datos exitosa';

            $opciones = array('http' =>
                array(
                    'method'  => 'POST',
                    'header'  => 'Content-type: application/x-www-form-urlencoded',

                )
            );

            $contexto = stream_context_create($opciones);
            $resultado = file_get_contents($this->url_api_conciliacion.'fechamaximacierremes', false, $contexto);
            $resultado=json_decode($resultado,true);
            

            $fechamaximacierremes=null;

            if(!empty($resultado['data'])){
                $fechamaximacierremes=$resultado['data'];
                
            }else{
                $fechamaximacierremes=null;
                
            }
            
            if($banco=='bancoguayaquil')
            {
                $f=$arrayArchivo[0];
                $fecha_pago =substr( $f, 7, 4 ) .'-'. substr( $f, 11, 2 ).'-'.substr( $f, 13, 2 );
                            
                //$fecha_pago = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_pago);            
                //$fecha_pago =$fecha_pago->format('Y-m-d');
    
                $f=$arrayArchivo[1];
                $f1=$arrayArchivo[2];
                
                for($i=1; $i<sizeOf($arrayArchivo); $i++)
                { 
                    $f=$arrayArchivo[$i];
                    if(substr( $f, 0, 1 )==2){
                    $fecha_transaccion =substr( $f, 297, 4 ) .'-'. substr( $f, 301, 2 ).'-'.substr( $f, 303, 2 );
                    //$fecha_transaccion = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_transaccion);
                    //$fecha_transaccion =$fecha_transaccion->format('Y-m-d');                                 
        
                    $comercio = substr( $f, 95, 10 );
                    $numero_retencion = substr( $f, 402, 17 );
                    $monto_depositado = intval(substr( $f, 60, 13 )).'.'.substr( $f, 73, 2 );
                    $total_pagar = intval(substr( $f, 124, 13 )).'.'.substr( $f, 137, 2 )+(intval(substr( $f, 169, 13 )).'.'.substr( $f, 182, 2 ));
                    $retencion_iva = intval(substr( $f, 184, 13 )).'.'.substr( $f, 197, 2 );
                    if($retencion_iva==0)
                    {
                        $retencion_iva='0.00';
                    }
                    $retencion_fuente = intval(substr( $f, 154, 13 )).'.'.substr( $f, 167, 2 );
                    $porcentaje_comision = '0.00';
                    $descuento_comision = intval(substr( $f, 139, 13 )).'.'.substr( $f, 152, 2 );
                    $iva_comision=intval(substr( $f, 203, 13 )).'.'.substr( $f, 216, 2 );
                    $descuento_comision=$descuento_comision+$iva_comision;
                    $autorizacion = substr( $f, 291, 6 );
                    $lote = (substr( $f, 4, 14 ));
                    $id_terminal = substr( $f, 325, 10 );
                    $cuentacontable_banco = substr( $f, 549, 10 ); 
                    $centro_costo=substr( $f, 559, 6 ); 
                    $numero_tarjeta=substr( $f, 105, 19 ); 
                    //print_r("si");
                    if($fecha_pago>$fechamaximacierremes ){//print_r("si1"); && $fecha_transaccion>$fechamaximacierremes
                        if($fecha_pago != null && $fecha_transaccion != null && $comercio != null &&  $numero_retencion != null &&  $monto_depositado != null &&  $total_pagar != null &&  $retencion_iva != null &&    $porcentaje_comision != null&&  $descuento_comision != null&&  $autorizacion != null &&  $lote != null&&  $id_terminal != null&&  $cuentacontable_banco != null){
        
                            //print_r("si2");
        
                            $total_descuento_comision=$total_descuento_comision+$descuento_comision;
                            $total_monto_depositado=$total_monto_depositado+$monto_depositado;
                            $total_total_pagar=$total_total_pagar+$total_pagar;
                            $total_retencion_iva=$total_retencion_iva+$retencion_iva;
                            $total_retencion_fuente=$total_retencion_fuente+$retencion_fuente;
                            $data[]= array( 
        
                                'fecha_pago'=>$fecha_pago,
                                'fecha_transaccion'=>$fecha_transaccion,
                                'comercio'=>$comercio,
                                'numero_retencion'=>$numero_retencion,
                                'monto_depositado'=>$monto_depositado,
                                'total_pagar'=>$total_pagar,
                                'retencion_iva'=>$retencion_iva,
                                'retencion_fuente'=>$retencion_fuente,
                                'porcentaje_comision'=>$porcentaje_comision,
                                'descuento_comision'=>$descuento_comision,
                                'autorizacion'=>$autorizacion,
                                'lote'=>$lote,
                                'id_terminal'=>$id_terminal,
                                'cuentacontable_banco'=>$cuentacontable_banco,
                                'centro_costo'=>$centro_costo,
                                'numero_tarjeta'=>$numero_tarjeta,
                            );
                        }else{
        
                            $lectura_total="ADVERTENCIA: algunas filas estan vacías, por favor compare los datos de la tabla y el archivo";
                        } 
                    }else{
                        $lectura_total="ADVERTENCIA: no puede ingresar fechas de un mes cerrado";
                    }     
                }}
            }else{
            foreach ($sheet->getRowIterator() as $row) {
                $cellIterator = $row->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false); 
                $highestRow = $sheet->getHighestDataRow();
                
                $highestColumn = $sheet->getHighestDataColumn(); 
                
                if($banco=='diners'){
                for($row=2; $row<=$highestRow; $row++)
                {

                    $f=$sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
                    $fecha_pago =substr( $f, 0, 4 ) .'-'. substr( $f, 4, 2 ).'-'.substr( $f, 6, 2 );
                                  
                    //$fecha_pago = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_pago);            
                    //$fecha_pago =$fecha_pago->format('Y-m-d');

                    $f=$sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
                    $fecha_transaccion =substr( $f, 0, 4 ) .'-'. substr( $f, 4, 2 ).'-'.substr( $f, 6, 2 );
                    //$fecha_transaccion = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_transaccion);
                    //$fecha_transaccion =$fecha_transaccion->format('Y-m-d');                                 

                    $comercio = $sheet->getCellByColumnAndRow(5, $row)->getValue();
                    $numero_retencion = $sheet->getCellByColumnAndRow(38, $row)->getValue();
                    if($numero_retencion==0)
                    {
                        $numero_retencion="0000";
                    }
                    $monto_depositado = $sheet->getCellByColumnAndRow(24, $row)->getValue();
                    $total_pagar = $sheet->getCellByColumnAndRow(19, $row)->getValue();
                    $retencion_iva = $sheet->getCellByColumnAndRow(34, $row)->getValue();
                    if($retencion_iva==0)
                    {
                        $retencion_iva='0.00';
                    }
                    $retencion_fuente = $sheet->getCellByColumnAndRow(35, $row)->getValue();
                    if($retencion_fuente==0)
                    {
                        $retencion_fuente='0.00';
                    }
                    $porcentaje_comision = $sheet->getCellByColumnAndRow(21, $row)->getValue();
                    $descuento_comision = $sheet->getCellByColumnAndRow(33, $row)->getValue();
                    if($descuento_comision==0)
                    {
                        $descuento_comision='0.00';
                    }
                    $autorizacion = '0000';
                    $lote = $sheet->getCellByColumnAndRow(9, $row)->getValue();
                    $id_terminal = $sheet->getCellByColumnAndRow(5, $row)->getValue();
                    $cuentacontable_banco = '11103007'; //Internacional
                    $centro_costo=$sheet->getCellByColumnAndRow(42, $row)->getValue();
                    $numero_tarjeta=$sheet->getCellByColumnAndRow(11, $row)->getValue();
                    
                    if ($id_terminal=='1514027')
                    {
                        $cuentacontable_banco = '3382270104'; //
                    }
                    if($fecha_transaccion == '1970-01-01'){
                        break;
                    }
                    if($fecha_pago == '1970-01-01'){
                        break;
                    }
                    

                    
                    
                    
                    if($fecha_pago>$fechamaximacierremes ){
                        if($fecha_pago != null && $fecha_transaccion != null && $comercio != null &&  $numero_retencion != null &&  $monto_depositado != null &&  $total_pagar != null &&  $retencion_iva != null &&    $porcentaje_comision != null&&  $descuento_comision != null&&  $autorizacion != null &&  $lote != null&&  $id_terminal != null&&  $cuentacontable_banco != null){



                            $total_descuento_comision=$total_descuento_comision+$descuento_comision;
                            $total_monto_depositado=$total_monto_depositado+$monto_depositado;
                            $total_total_pagar=$total_total_pagar+$total_pagar;
                            $total_retencion_iva=$total_retencion_iva+$retencion_iva;
                            $total_retencion_fuente=$total_retencion_fuente+$retencion_fuente;
                            $data[]= array( 

                                'fecha_pago'=>$fecha_pago,
                                'fecha_transaccion'=>$fecha_transaccion,
                                'comercio'=>$comercio,
                                'numero_retencion'=>$numero_retencion,
                                'monto_depositado'=>$monto_depositado,
                                'total_pagar'=>$total_pagar,
                                'retencion_iva'=>$retencion_iva,
                                'retencion_fuente'=>$retencion_fuente,
                                'porcentaje_comision'=>$porcentaje_comision,
                                'descuento_comision'=>$descuento_comision,
                                'autorizacion'=>$autorizacion,
                                'lote'=>$lote,
                                'id_terminal'=>$id_terminal,
                                'cuentacontable_banco'=>$cuentacontable_banco,
                                'centro_costo'=>$centro_costo,
                                'numero_tarjeta'=>$numero_tarjeta,
                            );
                        }else{

                            $lectura_total="ADVERTENCIA: algunas filas estan vacías, por favor compare los datos de la tabla y el excel";
                        } 
                    }else{
                        $lectura_total="ADVERTENCIA: no puede ingresar fechas de un mes cerrado";
                    }     
                }
            }
                if($banco=='bancointernacional'){
                for($row=2; $row<=$highestRow; $row++)
                {

                    $f=explode('/',$sheet->getCellByColumnAndRow(25, $row)->getCalculatedValue());
                    if(strlen($f[0])==1)
                    {
                        $f[0]='0'.$f[0];
                    }
                    if(strlen($f[1])==1)
                    {
                        $f[1]='0'.$f[1];
                    }
                    $fecha_pago = $sheet->getCellByColumnAndRow(25, $row)->getCalculatedValue(); 
                    $fecha_pago = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_pago);            
                    $fecha_pago =$fecha_pago->format('Y-m-d');

                    $f=explode('/',$sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue());
                    if(strlen($f[0])==1)
                    {
                        $f[0]='0'.$f[0];
                    }
                    if(strlen($f[1])==1)
                    {
                        $f[1]='0'.$f[1];
                    }
                    $fecha_transaccion = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue(); 
                    $fecha_transaccion = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_transaccion);
                    $fecha_transaccion =$fecha_transaccion->format('Y-m-d');                                 

                    $comercio = $sheet->getCellByColumnAndRow(5, $row)->getValue();
                    $numero_retencion = '0000';
                    $a=str_replace(',','.',sprintf('%.2f',$sheet->getCellByColumnAndRow(17, $row)->getValue()));
                    $b=str_replace(',','.',sprintf('%.2f',$sheet->getCellByColumnAndRow(14, $row)->getValue()));
                    $c=str_replace(',','.',sprintf('%.2f',$sheet->getCellByColumnAndRow(15, $row)->getValue()));
                    $d=str_replace(',','.',sprintf('%.2f',$sheet->getCellByColumnAndRow(16, $row)->getValue()));
                    $op=str_replace('.','.',sprintf(round(($a-$b-$c-$d)*1,2)));
                    $monto_depositado = str_replace('.','.',$sheet->getCellByColumnAndRow(17, $row)->getValue());
                    $total_pagar = str_replace('.','.',$sheet->getCellByColumnAndRow(13, $row)->getValue());
                    $retencion_iva = str_replace('.','.',$sheet->getCellByColumnAndRow(15, $row)->getValue());
                    if($retencion_iva==0)
                    {
                        $retencion_iva='0.00';
                    }
                    $retencion_fuente = str_replace('.','.',$sheet->getCellByColumnAndRow(16, $row)->getValue());
                    $porcentaje_comision = str_replace('.','.',$sheet->getCellByColumnAndRow(44, $row)->getValue());
                    $descuento_comision = str_replace('.','.',$sheet->getCellByColumnAndRow(14, $row)->getValue());
                    $autorizacion = $sheet->getCellByColumnAndRow(21, $row)->getValue();
                    $lote = intval((explode('-',$sheet->getCellByColumnAndRow(7, $row)->getValue()))[1]);
                    
                    $id_terminal = $sheet->getCellByColumnAndRow(5, $row)->getValue();
                    $cuentacontable_banco = '5200606477';
                    $centro_costo=$sheet->getCellByColumnAndRow(46, $row)->getValue();
                    $numero_tarjeta='0';
                    
                    if($fecha_transaccion == '1970-01-01'){
                        break;
                    }
                    if($fecha_pago == '1970-01-01'){
                        break;
                    }
                    

                    
                    
                    
                    if($fecha_pago>$fechamaximacierremes ){
                        if($fecha_pago != null && $fecha_transaccion != null && $comercio != null &&  $numero_retencion != null &&  $monto_depositado != null &&  $total_pagar != null &&  $retencion_iva != null &&   $porcentaje_comision != null&&  $descuento_comision != null&&  $autorizacion != null &&  $lote != null&&  $id_terminal != null&&  $cuentacontable_banco != null){



                            $total_descuento_comision=$total_descuento_comision+$descuento_comision;
                            $total_monto_depositado=$total_monto_depositado+$monto_depositado;
                            $total_total_pagar=$total_total_pagar+$total_pagar;
                            $total_retencion_iva=$total_retencion_iva+$retencion_iva;
                            $total_retencion_fuente=$total_retencion_fuente+$retencion_fuente;
                            $data[]= array( 

                                'fecha_pago'=>$fecha_pago,
                                'fecha_transaccion'=>$fecha_transaccion,
                                'comercio'=>$comercio,
                                'numero_retencion'=>$numero_retencion,
                                'monto_depositado'=>$monto_depositado,
                                'total_pagar'=>$total_pagar,
                                'retencion_iva'=>$retencion_iva,
                                'retencion_fuente'=>$retencion_fuente,
                                'porcentaje_comision'=>$porcentaje_comision,
                                'descuento_comision'=>$descuento_comision,
                                'autorizacion'=>$autorizacion,
                                'lote'=>$lote,
                                'id_terminal'=>$id_terminal,
                                'cuentacontable_banco'=>$cuentacontable_banco,
                                'centro_costo'=>$centro_costo,
                                'numero_tarjeta'=>$numero_tarjeta,
                            );
                        }else{

                            $lectura_total="ADVERTENCIA: algunas filas estan vacías, por favor compare los datos de la tabla y el excel";
                        } 
                    }else{
                        $lectura_total="ADVERTENCIA: no puede ingresar fechas de un mes cerrado";
                    }     
                }
            }
                if($banco=='bancoaustro'){
                for($row=2; $row<=$highestRow; $row++)
                {
                    $f=$sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();            
                    $fecha_pago = substr( $f, 0, 4 ) .'-'. substr( $f, 4, 2 ).'-'.substr( $f, 6, 2 );   
                    //$fecha_pago = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_pago);            
                   // $fecha_pago =date('YYYY-mm-dd',$fecha_pago);

                    $f1=$sheet->getCellByColumnAndRow(2, $row)->getCalculatedValue();
                    $fecha_transaccion = substr( $f1, 0, 4 ) .'-'. substr( $f1, 4, 2 ).'-'.substr( $f1, 6, 2 );               
                    //$fecha_transaccion = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_transaccion);
                    //$fecha_transaccion =date('Y-m-d',$fecha_transaccion);                                 

                    $comercio = $sheet->getCellByColumnAndRow(3, $row)->getValue();
                    $numero_retencion = $sheet->getCellByColumnAndRow(11, $row)->getValue();
                    $monto_depositado = $sheet->getCellByColumnAndRow(23, $row)->getValue();
                    $total_pagar = $sheet->getCellByColumnAndRow(18, $row)->getValue();
                    $retencion_iva = $sheet->getCellByColumnAndRow(19, $row)->getValue();
                    if($retencion_iva==0)
                    {
                        $retencion_iva='0.00';
                    }
                    $retencion_fuente = $sheet->getCellByColumnAndRow(22, $row)->getValue();
                    $porcentaje_comision = $sheet->getCellByColumnAndRow(20, $row)->getValue();
                    $descuento_comision = $sheet->getCellByColumnAndRow(21, $row)->getValue();
                    $autorizacion = $sheet->getCellByColumnAndRow(30, $row)->getValue();
                    $lote = $sheet->getCellByColumnAndRow(31, $row)->getValue();
                    $centro_costo=$sheet->getCellByColumnAndRow(34, $row)->getValue();
                    $numero_tarjeta=$sheet->getCellByColumnAndRow(25, $row)->getValue();
                    if($lote=='')
                    {
                        $lote='0000';
                    }
                    if($comercio=='')
                    {
                        $comercio='0000';
                    }
                    $id_terminal = $sheet->getCellByColumnAndRow(33, $row)->getValue();
                    $cuentacontable_banco = '180255822';
                    
                    if($fecha_transaccion == '1970-01-01'){
                        break;
                    }
                    if($fecha_pago == '1970-01-01'){
                        break;
                    }
                    

                    
                    
                    
                    if($fecha_pago>$fechamaximacierremes ){
                        if($fecha_pago != null && $fecha_transaccion != null && $comercio != null &&  $numero_retencion != null &&  $monto_depositado != null &&  $total_pagar != null &&  $retencion_iva != null &&   $porcentaje_comision != null&&  $descuento_comision != null&&  $autorizacion != null &&  $lote != null&&  $id_terminal != null&&  $cuentacontable_banco != null){



                            $total_descuento_comision=$total_descuento_comision+$descuento_comision;
                            $total_monto_depositado=$total_monto_depositado+$monto_depositado;
                            $total_total_pagar=$total_total_pagar+$total_pagar;
                            $total_retencion_iva=$total_retencion_iva+$retencion_iva;
                            $total_retencion_fuente=$total_retencion_fuente+$retencion_fuente;
                            $data[]= array( 

                                'fecha_pago'=>$fecha_pago,
                                'fecha_transaccion'=>$fecha_transaccion,
                                'comercio'=>$comercio,
                                'numero_retencion'=>$numero_retencion,
                                'monto_depositado'=>$monto_depositado,
                                'total_pagar'=>$total_pagar,
                                'retencion_iva'=>$retencion_iva,
                                'retencion_fuente'=>$retencion_fuente,
                                'porcentaje_comision'=>$porcentaje_comision,
                                'descuento_comision'=>$descuento_comision,
                                'autorizacion'=>$autorizacion,
                                'lote'=>$lote,
                                'id_terminal'=>$id_terminal,
                                'cuentacontable_banco'=>$cuentacontable_banco,
                                'centro_costo'=>$centro_costo,
                                'numero_tarjeta'=>$numero_tarjeta,
                            );
                        }else{

                            $lectura_total="ADVERTENCIA: algunas filas estan vacías, por favor compare los datos de la tabla y el excel";
                        } 
                    }else{
                        $lectura_total="ADVERTENCIA: no puede ingresar fechas de un mes cerrado";
                    }     
                }
            }
                if($banco=='bancopacifico'){
                for($row=2; $row<=$highestRow; $row++)
                {
                    $f=$sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
                    
                    $fecha_pago = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($f);            
                    $fecha_pago =$fecha_pago->format('Y-m-d');

                    $f=$sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue();
                    
                    $fecha_transaccion = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($f);
                    $fecha_transaccion =$fecha_transaccion->format('Y-m-d');                                 

                    $comercio = $sheet->getCellByColumnAndRow(2, $row)->getValue();
                    $numero_retencion = $sheet->getCellByColumnAndRow(21, $row)->getValue();
                    $monto_depositado = $sheet->getCellByColumnAndRow(18, $row)->getValue();
                    if($monto_depositado==0)
                    {
                        $monto_depositado='0.00';
                    }
                    $total_pagar = $sheet->getCellByColumnAndRow(14, $row)->getValue()-$sheet->getCellByColumnAndRow(13, $row)->getValue();
                    if($total_pagar==0)
                    {
                        $total_pagar='0.00';
                    }
                    $retencion_iva = $sheet->getCellByColumnAndRow(16, $row)->getValue();
                    if($retencion_iva==0)
                    {
                        $retencion_iva='0.00';
                    }
                    $retencion_fuente = $sheet->getCellByColumnAndRow(17, $row)->getValue();
                    $porcentaje_comision ='0';
                    $descuento_comision = $sheet->getCellByColumnAndRow(15, $row)->getValue();
                    $autorizacion = $sheet->getCellByColumnAndRow(22, $row)->getValue();
                    $lote =$sheet->getCellByColumnAndRow(2, $row)->getValue();
                    
                    $id_terminal = $sheet->getCellByColumnAndRow(22, $row)->getValue();
                    $cuentacontable_banco = $sheet->getCellByColumnAndRow(6, $row)->getValue();
                    $centro_costo=$sheet->getCellByColumnAndRow(24, $row)->getValue();
                    $numero_tarjeta=$sheet->getCellByColumnAndRow(8, $row)->getValue();
                    if($fecha_transaccion == '1970-01-01'){
                        break;
                    }
                    if($fecha_pago == '1970-01-01'){
                        break;
                    }
                    

                    
                    
                    
                    if($fecha_pago>$fechamaximacierremes ){
                        if($fecha_pago != null && $fecha_transaccion != null && $comercio != null &&  $numero_retencion != null &&  $monto_depositado != null &&  $total_pagar != null &&  $retencion_iva != null &&   $descuento_comision != null&&  $autorizacion != null &&  $lote != null&&  $id_terminal != null&&  $cuentacontable_banco != null){



                            $total_descuento_comision=$total_descuento_comision+$descuento_comision;
                            $total_monto_depositado=$total_monto_depositado+$monto_depositado;
                            $total_total_pagar=$total_total_pagar+$total_pagar;
                            $total_retencion_iva=$total_retencion_iva+$retencion_iva;
                            $total_retencion_fuente=$total_retencion_fuente+$retencion_fuente;
                            $data[]= array( 

                                'fecha_pago'=>$fecha_pago,
                                'fecha_transaccion'=>$fecha_transaccion,
                                'comercio'=>$comercio,
                                'numero_retencion'=>$numero_retencion,
                                'monto_depositado'=>$monto_depositado,
                                'total_pagar'=>$total_pagar,
                                'retencion_iva'=>$retencion_iva,
                                'retencion_fuente'=>$retencion_fuente,
                                'porcentaje_comision'=>$porcentaje_comision,
                                'descuento_comision'=>$descuento_comision,
                                'autorizacion'=>$autorizacion,
                                'lote'=>$lote,
                                'id_terminal'=>$id_terminal,
                                'cuentacontable_banco'=>$cuentacontable_banco,
                                'centro_costo'=>$centro_costo,
                                'numero_tarjeta'=>$numero_tarjeta,
                            );
                        }else{

                            $lectura_total="".$fecha_pago.'--'. $fecha_transaccion .'--'. $comercio.'--'. $numero_retencion .'--'.  $monto_depositado .'--'.  $total_pagar .'--'.  $retencion_iva.'--'.  $retencion_fuente .'--'. $porcentaje_comision .'--'. $descuento_comision .'--'.  $autorizacion.'--'. $lote .'--'. $id_terminal .'--'.  $cuentacontable_banco;
                        } 
                    }else{
                        $lectura_total="ADVERTENCIA: no puede ingresar fechas de un mes cerrado";
                    }     
                }
            }
                if($banco=='bancosolidario'){
                for($row=2; $row<=$highestRow; $row++)
                {

                    $f=explode('/',$sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue());
                    if(strlen($f[0])==1)
                    {
                        $f[0]='0'.$f[0];
                    }
                    if(strlen($f[1])==1)
                    {
                        $f[1]='0'.$f[1];
                    }
                    $fecha_pago = $f[2].'-'.$f[0].'-'.$f[1];  
                    
                    //$fecha_pago = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_pago);            
                    //$fecha_pago =$fecha_pago->format('Y-m-d');

                    $f=explode('/',$sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue());
                    if(strlen($f[0])==1)
                    {
                        $f[0]='0'.$f[0];
                    }
                    if(strlen($f[1])==1)
                    {
                        $f[1]='0'.$f[1];
                    }
                    $fecha_transaccion = $f[2].'-'.$f[0].'-'.$f[1];  
                    //$fecha_transaccion = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_transaccion);
                    //$fecha_transaccion =$fecha_transaccion->format('Y-m-d');                                 

                    $comercio = $sheet->getCellByColumnAndRow(18, $row)->getValue();
                    $numero_retencion = '0';
                    $monto_depositado = $sheet->getCellByColumnAndRow(16, $row)->getValue();
                    $total_pagar = $sheet->getCellByColumnAndRow(8, $row)->getValue();
                    $retencion_iva = $sheet->getCellByColumnAndRow(11, $row)->getValue();
                    if($retencion_iva==0)
                    {
                        $retencion_iva='0.00';
                    }
                    $retencion_fuente = $sheet->getCellByColumnAndRow(12, $row)->getValue();
                    $porcentaje_comision =$sheet->getCellByColumnAndRow(28, $row)->getValue();;
                    $descuento_comision = $sheet->getCellByColumnAndRow(13, $row)->getValue();
                    $autorizacion = $sheet->getCellByColumnAndRow(4, $row)->getValue();
                    $lote =$sheet->getCellByColumnAndRow(17, $row)->getValue();
                    
                    $id_terminal = $sheet->getCellByColumnAndRow(7, $row)->getValue();
                    $cuentacontable_banco = '5200606477';
                    $centro_costo=$sheet->getCellByColumnAndRow(27, $row)->getValue();
                    $numero_tarjeta='XX-XXXX-XXXX-XXXX';
                    if($fecha_transaccion == '1970-01-01'){
                        break;
                    }
                    if($fecha_pago == '1970-01-01'){
                        break;
                    }
                    

                    
                    
                    
                    if($fecha_pago>$fechamaximacierremes){
                        if($fecha_pago != null && $fecha_transaccion != null && $comercio != null &&  $numero_retencion != null &&  $monto_depositado != null &&  $total_pagar != null  &&  $porcentaje_comision != null&&  $descuento_comision != null&&  $autorizacion != null &&  $lote != null&&  $id_terminal != null&&  $cuentacontable_banco != null){



                            $total_descuento_comision=$total_descuento_comision+$descuento_comision;
                            $total_monto_depositado=$total_monto_depositado+$monto_depositado;
                            $total_total_pagar=$total_total_pagar+$total_pagar;
                            $total_retencion_iva=$total_retencion_iva+$retencion_iva;
                            $total_retencion_fuente=$total_retencion_fuente+$retencion_fuente;
                            $data[]= array( 

                                'fecha_pago'=>$fecha_pago,
                                'fecha_transaccion'=>$fecha_transaccion,
                                'comercio'=>$comercio,
                                'numero_retencion'=>$numero_retencion,
                                'monto_depositado'=>$monto_depositado,
                                'total_pagar'=>$total_pagar,
                                'retencion_iva'=>$retencion_iva,
                                'retencion_fuente'=>$retencion_fuente,
                                'porcentaje_comision'=>$porcentaje_comision,
                                'descuento_comision'=>$descuento_comision,
                                'autorizacion'=>$autorizacion,
                                'lote'=>$lote,
                                'id_terminal'=>$id_terminal,
                                'cuentacontable_banco'=>$cuentacontable_banco,
                                'centro_costo'=>$centro_costo,
                                'numero_tarjeta'=>$numero_tarjeta,
                            );
                        }else{

                            $lectura_total="ADVERTENCIA: algunas filas están vacías, por favor compare los datos de la tabla y el excel";
                        } 
                    }else{
                        $lectura_total="ADVERTENCIA: no puede ingresar fechas de un mes cerrado";
                    }     
                }
            }
                if($banco=='bancobolivariano'){
                for($row=2; $row<=$highestRow; $row++)
                {

                    $f=explode('/',$sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue());
                    if(strlen($f[0])==1)
                    {
                        $f[0]='0'.$f[0];
                    }
                    if(strlen($f[1])==1)
                    {
                        $f[1]='0'.$f[1];
                    }
                    $fecha_pago = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue(); 
                    $fecha_pago = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_pago);            
                    $fecha_pago =$fecha_pago->format('Y-m-d');

                    $f=explode('/',$sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue());
                    if(strlen($f[0])==1)
                    {
                        $f[0]='0'.$f[0];
                    }
                    if(strlen($f[1])==1)
                    {
                        $f[1]='0'.$f[1];
                    }
                    $fecha_transaccion = $sheet->getCellByColumnAndRow(1, $row)->getCalculatedValue(); 
                    $fecha_transaccion = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($fecha_transaccion);
                    $fecha_transaccion =$fecha_transaccion->format('Y-m-d');                                 

                    $comercio = '0';
                    $numero_retencion = '0000';
                    $monto_depositado = str_replace('.','.',$sheet->getCellByColumnAndRow(26, $row)->getValue());
                    $total_pagar = str_replace('.','.',$sheet->getCellByColumnAndRow(22, $row)->getValue());
                    $retencion_iva = str_replace('.','.',$sheet->getCellByColumnAndRow(24, $row)->getValue());
                    if($retencion_iva==0)
                    {
                        $retencion_iva='0.00';
                    }
                    $retencion_fuente = str_replace('.','.',$sheet->getCellByColumnAndRow(25, $row)->getValue());
                    $porcentaje_comision = str_replace('.','.',$sheet->getCellByColumnAndRow(14, $row)->getValue());
                    $descuento_comision = str_replace('.','.',$sheet->getCellByColumnAndRow(23, $row)->getValue());
                    $autorizacion = $sheet->getCellByColumnAndRow(9, $row)->getValue();
                    $lote = intval((explode('-',$sheet->getCellByColumnAndRow(7, $row)->getValue()))[1]);
                    
                    $id_terminal = $sheet->getCellByColumnAndRow(28, $row)->getValue();
                    $cuentacontable_banco = '5200606477';
                    $centro_costo=$sheet->getCellByColumnAndRow(27, $row)->getValue();
                    $numero_tarjeta=$sheet->getCellByColumnAndRow(10, $row)->getValue();;
                    
                    if($fecha_transaccion == '1970-01-01'){
                        break;
                    }
                    if($fecha_pago == '1970-01-01'){
                        break;
                    }
                    

                    
                    
                    
                    if($fecha_pago>$fechamaximacierremes ){
                        if($fecha_pago != null && $fecha_transaccion != null && $comercio != null &&  $numero_retencion != null &&  $monto_depositado != null &&  $total_pagar != null &&  $retencion_iva != null &&    $porcentaje_comision != null&&  $descuento_comision != null&&  $autorizacion != null &&  $lote != null&&  $id_terminal != null&&  $cuentacontable_banco != null){



                            $total_descuento_comision=$total_descuento_comision+$descuento_comision;
                            $total_monto_depositado=$total_monto_depositado+$monto_depositado;
                            $total_total_pagar=$total_total_pagar+$total_pagar;
                            $total_retencion_iva=$total_retencion_iva+$retencion_iva;
                            $total_retencion_fuente=$total_retencion_fuente+$retencion_fuente;
                            $data[]= array( 

                                'fecha_pago'=>$fecha_pago,
                                'fecha_transaccion'=>$fecha_transaccion,
                                'comercio'=>$comercio,
                                'numero_retencion'=>$numero_retencion,
                                'monto_depositado'=>$monto_depositado,
                                'total_pagar'=>$total_pagar,
                                'retencion_iva'=>$retencion_iva,
                                'retencion_fuente'=>$retencion_fuente,
                                'porcentaje_comision'=>$porcentaje_comision,
                                'descuento_comision'=>$descuento_comision,
                                'autorizacion'=>$autorizacion,
                                'lote'=>$lote,
                                'id_terminal'=>$id_terminal,
                                'cuentacontable_banco'=>$cuentacontable_banco,
                                'centro_costo'=>$centro_costo,
                                'numero_tarjeta'=>$numero_tarjeta,
                            );
                        }else{

                            $lectura_total="ADVERTENCIA: algunas filas estan vacías, por favor compare los datos de la tabla y el excel";
                        } 
                    }else{
                        $lectura_total="ADVERTENCIA: no puede ingresar fechas de un mes cerrado";
                    }     
                }
            }
                break;
                
            }}
            $diferencia=$total_total_pagar-($total_descuento_comision+$total_monto_depositado+$total_retencion_iva+$total_retencion_fuente);
            $diferencia=floatval(round($diferencia, 2, PHP_ROUND_HALF_DOWN));
            if($diferencia!=0)
            {
                $session->setFlashdata('mensaje_malo', 'Existe una diferencia de '.$diferencia);
            }
            if($data!=null ){
                $datos= array(
                    "data"=>$data,
                    "seleccionar"=>$respuesta,
                    "total_descuento_comision"=>$total_descuento_comision,
                    "total_monto_depositado"=>$total_monto_depositado,
                    "total_total_pagar"=>$total_total_pagar,
                    "total_retencion_iva"=>$total_retencion_iva,
                    "total_retencion_fuente"=>$total_retencion_fuente,
                    "nombre_archivo"=>$nombre_archivo,
                    "mensaje"=>$lectura_total,
                    "banco_pagador"=>$banco
                    
                );
                echo view("layouts/header");
                echo view("layouts/aside");
                echo view("formatocarga/tabla",$datos);
                echo view("layouts/footer");
            }else{
                $session->setFlashdata('mensaje_malo', $lectura_total);
                return redirect()->to(base_url('FormatoCarga')); 
            }
        }else{
            $session->setFlashdata('mensaje_malo', 'Seleccione un archivo');
            return redirect()->to(base_url('FormatoCarga')); 
        }
        }
        catch (Exception $e) {
            $session->setFlashdata('mensaje_malo', 'Error al seleccionar el banco pagador');
            return redirect()->to(base_url('FormatoCarga')); 
        }
        
    }

    public function finalizar (){
        $session = \Config\Services::session();
                
        if(empty($session->get('fullName')) && empty($session->get('referenceId')) ){
            return redirect()->to(base_url());
        }
        if($_POST["cuentabanco"]!=''){
        $bancoArchivo=$_POST["bancoarchivo"];
        $bancoPagadorCuenta=$_POST["cuentabanco"];
        $nombrebanco = $_POST["nombrebanco"];//AQUI VIENE EL ID DEL BANCO
        $total_monto_depositado = $_POST["total_monto_depositado"];
        $total_total_pagar = $_POST["total_total_pagar"];
        $total_retencion_iva = $_POST["total_retencion_iva"];
        $total_retencion_fuente = $_POST["total_retencion_fuente"];
        $total_descuento_comision = $_POST["total_descuento_comision"];
        $nombre_archivo = $_POST["nombre_archivo"];
        $fecha = $_POST["fecha"];
        $valores = $_POST['valores'];
        $datos=unserialize(base64_decode($valores));

        //print_r($datos);

        $datos_cabecera=array(
            "pac_descuento_comision"=> $total_descuento_comision,
            "pac_monto_depositado"=> $total_monto_depositado,
            "pac_total_pagar"=> $total_total_pagar,
            "pac_retencion_iva"=> $total_retencion_iva,
            "pac_retencion_fuente"=> $total_retencion_fuente,
            "bap_id"=> $nombrebanco,
            "pac_fecha_carga"=> $fecha,
            "pac_nombre_archivo"=> $nombre_archivo,
            "id_usuario"=> $session->get('referenceId'),
            "nombre_usuario"=> $session->get('fullName'),
            "pac_estado"=> 1,         
        );

        $enviar_datos=array(
            'datos_cabecera'=>$datos_cabecera,
            'datos_detalle'=>$datos
        );
        
        $opciones = array('http' =>
            array(
                'timeout' => 1200,
                'method'  => 'POST',
                'header'  => 'Content-type: application/json',
                'content' => json_encode($enviar_datos),
                
            )
        );
        ini_set('default_socket_timeout', 900);
        set_time_limit(190);
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'pagocabeceradatoscabeceradetalle', false, $contexto);
        $resultado=json_decode($resultado,true); 
        
        
        if(!empty($resultado)){
            if($resultado['code']==200){
        $datosfechas=array();
        $datosfechasU=array();
        $i=0;
        //print_r(count($datos));
        
        foreach($datos as $d)
        {
            
            $datosfechas[$i]=$d["fecha_pago"];
            $i++;
        }
        
        $datosfechasU=array_unique($datosfechas);
        //print_r($datosfechasU);
        
        //CREAR ASIENTO CONTABLE
        
        $totalRI=0;
        $totalRF=0;
        $totalc=0;
        $totalMontoDepositado=0.00;
        $i=0;
        
        $arrayRI2=array();
        
        $arrayRF2=array();
        
        $arrayC2=array();
        
        $i=1;
        $referenciacontable='';
        foreach($datosfechasU as $df)
        {
            
            foreach($datos as $d)
            {
                
                if($d['fecha_pago']==$df)
                {
                    if(floatval($d['retencion_iva'])!=0){
                        $RI2=array('valor'=>str_replace(',','.',$d['retencion_iva']),'centroCosto'=>$d['centro_costo']);
                        array_push($arrayRI2,$RI2);}
                    if(floatval($d['retencion_fuente'])!=0){
                        $RF2=array('valor'=>str_replace(',','.',$d['retencion_fuente']),'centroCosto'=>$d['centro_costo']);
                        array_push($arrayRF2,$RF2);}
                    if(floatval($d['descuento_comision'])!=0){
                        $C2=array('valor'=>str_replace(',','.',$d['descuento_comision']),'centroCosto'=>$d['centro_costo']);
                        array_push($arrayC2,$C2);}
                    $totalRI=str_replace(',','.',$d['retencion_iva'])+$totalRI;
                    $totalRF=str_replace(',','.',$d['retencion_fuente'])+$totalRF;
                    $totalc=str_replace(',','.',$d['descuento_comision'])+$totalc;
                    $i++;
                    $idBanco=$nombrebanco;
                    $detalleBanco=$bancoPagadorCuenta;
                    //print_r(str_replace(',','.',$d['monto_depositado']).'-----////------');
                    $totalMontoDepositado=str_replace(',','.',$d['monto_depositado'])+$totalMontoDepositado;
                    //print_r($totalMontoDepositado.'-----');
                    
                }
            }
            
            
                     $enviar=array(
                    'cabeceraId'=>$resultado['data'].'-'.$df,
                    'fechaConciliacion'=>date("Y-m-d").' 00:00:00',
                    'fechaAsientoContable'=>$df.' 00:00:00',
                    'usuario'=>'CACHAPI',
                    'descripcion'=>$bancoArchivo,
                    'd_idCargoBanco'=>$idBanco,//'5637145328',
                    'd_DetalleBanco'=>$detalleBanco,//'3382270104 BANCO PICHINCHA',
                    'd_ValorBanco'=>str_replace(',','.',$totalMontoDepositado),
                    'd_idCargoRetencionRenta'=>'5637144612',
                    'd_DetalleRetencionRenta'=>'11203001 Impuesto Retenido Renta',
                    'd_ValorRetencionRenta'=>$arrayRF2,
                    'd_idCargoRetencionIva'=>'5637147578',
                    'd_DetalleRetencionIva'=>'11203010 Retenciones Iva recibidas',
                    'd_valorRetenidoIva'=>$arrayRI2,
                    'd_idGastoServiciosBancarios'=>'5637145368',
                    'd_DetalleGastosServiciosBancarios'=>'62101001 Gastos Servicios Bancarios',
                    'd_ValorServiciosBancarios'=>$arrayC2,
                    'h_idCargoCuentaClientesTarjetaCredito'=>'5637144631',
                    'h_DetalleCuentaClientesTarjetaCredito'=>'11205006 Clientes Tarjeta de Credito',
                    'h_ValorCuentaClientesTarjetaCredito'=>str_replace(',','.',$totalMontoDepositado+$totalRI+$totalRF+$totalc),
                    
                );
                
                //print_r($enviar);
                
                  $resultado_conciliacion=$this->enviar_conciliacion($enviar,$resultado['data']);
                  $referenciacontable=$referenciacontable.'-----'.$df.'=>'.$resultado_conciliacion['numero_conciliacion'];
                
                
                
                
                $arrayRI2=array();
        
                $arrayRF2=array();
        
                $arrayC2=array();
                
                $totalRI=0;
                $totalRF=0;
                $totalc=0;
                $totalMontoDepositado=0;
                
                
        }
        
          $this->agregar_referencia_contable($resultado['data'],$referenciacontable);
        //print_r($enviar);

              $session->setFlashdata('mensaje_bueno', 'Documento ingresado y enviado a Microsoft Dynamics con éxito');
              return redirect()->to(base_url('FormatoCarga'));
           }else{
               $session->setFlashdata('mensaje_malo', 'No Ingresado');
               return redirect()->to(base_url('FormatoCarga'));
           }
       }else{
           $session->setFlashdata('mensaje_malo', 'No Ingresado');
           return redirect()->to(base_url('FormatoCarga'));
       }

           }
        else
        {
            $session->setFlashdata('mensaje_malo', 'Seleccione el banco pagador');
            return redirect()->to(base_url('FormatoCarga'));
        }


}
    
    
}