<?php

namespace App\Controllers;


class Conciliacion extends BaseController
{

    public function index(){  

        if(isset($_POST["lote"])){$lote = $_POST["lote"];}else{$lote='';}
        if(isset($_POST["fechapago"])){$fechapago = $_POST["fechapago"];}else{$fechapago='';}
        if(isset($_POST["fechapagofin"])){$fechapagofin = $_POST["fechapagofin"];}else{$fechapagofin='';}
        if(isset($_POST["autorizacion"])){$autorizacion = $_POST["autorizacion"];}else{$autorizacion='';}
        if(isset($_POST["centrocosto"])){$centrocosto = $_POST["centrocosto"];}else{$centrocosto='';}
        if(isset($_POST["fechatransaccion"])){$fechatransaccion = $_POST["fechatransaccion"];}else{$fechatransaccion='';}
        if(isset($_POST["fechatransaccionfin"])){$fechatransaccionfin = $_POST["fechatransaccionfin"];}else{$fechatransaccionfin='';}
        if(isset($_POST["valormin"])){$valormin = $_POST["valormin"];}else{$valormin='';}
        if(isset($_POST["valormax"])){$valormax = $_POST["valormax"];}else{$valormax='';}
        if(isset($_POST["tic"])){$tic = $_POST["tic"];}else{$tic='';}
        if(isset($_POST["fechapagoventafin"])){$fechapagoventafin = $_POST["fechapagoventafin"];}else{$fechapagoventafin='';}
        if(isset($_POST["fechapagoventa"])){$fechapagoventa = $_POST["fechapagoventa"];}else{$fechapagoventa='';}
        
        $datos_post = http_build_query(

            array(
                'pad_fecha_pago'=>$fechapago,
                'pad_fecha_pago_fin'=>$fechapagofin,
                'pad_lote'=>$lote,
                'pad_autorizacion'=>$autorizacion,
                'pad_fecha_transaccion'=>$fechapagoventa,
                'pad_fecha_transaccion_fin'=>$fechapagoventafin,
                'tic_id'=>!empty($tic)?$tic:1,
                'pad_monto_depositado_min'=>$valormin,
                'pad_monto_depositado_max'=>$valormax,
            )
        );


        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'pagodetallefiltro', false, $contexto);
        $resultado_pago_detalle=json_decode($resultado,true);


        $datos_post = http_build_query(
            array(
                'ven_fecha_pago'=>$fechapago,
                'ven_lote'=>$lote,
                'ven_autorizacion'=>$autorizacion,
                'ven_centro_costo'=>$centrocosto,
                'ven_fecha_transaccion'=>$fechatransaccion,
                'ven_fecha_transaccion_fin'=>$fechatransaccionfin,
                'tic_id'=>!empty($tic)?$tic:1,
                'ven_monto_min'=>$valormin,
                'ven_monto_max'=>$valormax,
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'ventafiltro', false, $contexto);
        $resultado_venta1=json_decode($resultado,true);  
        $resultado_venta=array_unique($resultado_venta1);
        //print_r($resultado_venta);
        
        $datos=array(               
            'datos_venta'=>!empty($resultado_venta['data']) ? $resultado_venta['data'] : [] ,
            'datos_pago_detalle'=>!empty($resultado_pago_detalle['data']) ? $resultado_pago_detalle['data'] : []  ,
            'lote'=>$lote,
            'fechapago'=>$fechapago,
            'fechapagofin'=>$fechapagofin,
            'autorizacion'=>$autorizacion,
            'centrocosto'=>$centrocosto,
            'fechatransaccion'=>$fechatransaccion,
            'fechatransaccionfin'=>$fechatransaccionfin,
            'valormin'=>$valormin,
            'valormax'=>$valormax,
            'tic'=>$tic,
        );

        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("conciliacion/vistaconciliacion",$datos);
        echo view("layouts/footer");
    }
    public function filtro(){

        $lote = $_POST["lote"];
        $fechapago = $_POST["fechapago"];
        $fechapagofin = $_POST["fechapagofin"];
        $autorizacion = $_POST["autorizacion"];
        $centrocosto = $_POST["centrocosto"];
        $fechatransaccion = $_POST["fechatransaccion"];
        $fechatransaccionfin = $_POST["fechatransaccionfin"];
        $valormin = $_POST["valormin"];        
        $valormax = $_POST["valormax"];        
        $tic = $_POST["tic"];
        
        if(isset($_POST["fechapagoventafin"])){$fechapagoventafin = $_POST["fechapagoventafin"];}else{$fechapagoventafin='';}
        if(isset($_POST["fechapagoventa"])){$fechapagoventa = $_POST["fechapagoventa"];}else{$fechapagoventa='';}
        
        $datos_post = http_build_query(

            array(
                'pad_fecha_pago'=>$fechapago,
                'pad_fecha_pago_fin'=>$fechapagofin,
                'pad_lote'=>$lote,
                'pad_autorizacion'=>$autorizacion,
                'pad_fecha_transaccion'=>$fechapagoventa,
                'pad_fecha_transaccion_fin'=>$fechapagoventafin,
                'tic_id'=>!empty($tic)?$tic:1,
                'pad_monto_depositado_min'=>$valormin,
                'pad_monto_depositado_max'=>$valormax,
            )
        );


        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'pagodetallefiltro', false, $contexto);
        $resultado_pago_detalle=json_decode($resultado,true);


        $datos_post = http_build_query(
            array(
                'ven_fecha_pago'=>$fechapago,
                'ven_lote'=>$lote,
                'ven_autorizacion'=>$autorizacion,
                'ven_centro_costo'=>$centrocosto,
                'ven_fecha_transaccion'=>$fechatransaccion,
                'ven_fecha_transaccion_fin'=>$fechatransaccionfin,
                'tic_id'=>!empty($tic)?$tic:1,
                'ven_monto_min'=>$valormin,
                'ven_monto_max'=>$valormax,
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'ventafiltro', false, $contexto);
        $resultado_venta1=json_decode($resultado,true);  
        $resultado_venta=array_unique($resultado_venta1);
        //print_r($resultado_venta);
        
        $datos=array(               
            'datos_venta'=>!empty($resultado_venta['data']) ? $resultado_venta['data'] : [] ,
            'datos_pago_detalle'=>!empty($resultado_pago_detalle['data']) ? $resultado_pago_detalle['data'] : []  ,
            'lote'=>$lote,
            'fechapago'=>$fechapago,
            'fechapagofin'=>$fechapagofin,
            'autorizacion'=>$autorizacion,
            'centrocosto'=>$centrocosto,
            'fechatransaccion'=>$fechatransaccion,
            'fechatransaccionfin'=>$fechatransaccionfin,
            'valormin'=>$valormin,
            'valormax'=>$valormax,
            'tic'=>$tic,
        );

        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("conciliacion/vistaconciliacion",$datos);
        echo view("layouts/footer");
        

    }    

    public function between($numero,$entre){
        $entre_mayor=$entre+0.02;
        $entre_menor=$entre-0.02;

        if($numero>=$entre_menor && $numero<=$entre_mayor){
            return true;
        }else{
            return false;
        }

    }
    public function banco_tipo_pago(){
        $opciones = array('http' =>
            array(
                'method'  => 'GET',
                'header'  => array(
                    'Content-type: application/x-www-form-urlencoded',
                ),         
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'relacionbancotipopago', false, $contexto);
        $resultado=json_decode($resultado,true);
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }
    }
    public function porcentaje_comision($pad_cuenta_contable_banco,$ban_codigo_banco,$tac_codigo,$tip_tipo_pago,$rbt_numero_cuotas,$rbt_meses_gracia){
        $datos_post = http_build_query(
            array(
                "pad_cuenta_contable_banco"=> $pad_cuenta_contable_banco,
                "ban_codigo_banco"=> $ban_codigo_banco,
                "tac_codigo"=> $tac_codigo,
                "tip_tipo_pago"=> $tip_tipo_pago,
                "rbt_numero_cuotas"=> $rbt_numero_cuotas,
                "rbt_meses_gracia"=> $rbt_meses_gracia,
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'relacionbancotipopagoporcentajecomision', false, $contexto);
        $resultado=json_decode($resultado,true);  

        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }
    }

    public function validarautorizacion($autorizacion_venta,$autorizacion_pago){
        if(strstr($autorizacion_pago, $autorizacion_venta)){
            return true;
        }else{
            if(strstr($autorizacion_venta, $autorizacion_pago)){
                return true;
            }else{
                return false;
            }
        }
        return false;
    }
    
    public function validarfechas($fecha_venta, $fecha_pago)
    {
        if($fecha_venta==$fecha_pago)
        {
            return true;
        }
        else
        {
            if(date("Y-m-d",strtotime($fecha_venta."+ 1 days"))==$fecha_pago )
            {
                return true;
            }
            else
            {
                if(date("Y-m-d",strtotime($fecha_venta."+ 2 days"))==$fecha_pago )
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
    }
    public function conciliacionautomatica(){
        $session = \Config\Services::session();


        if(empty($session->get('fullName')) && empty($session->get('referenceId')) ){
            return redirect()->to(base_url());
        }
        
        if(!empty($_POST['dato_pago'])){
            $dato_pago = $_POST['dato_pago'];
            $datos_pago_detalle=unserialize(base64_decode($dato_pago));
        }
        if(!empty($_POST['dato_venta'])){
            $dato_venta = $_POST['dato_venta'];
            $datos_venta=unserialize(base64_decode($dato_venta));
        }   

        $salida=null;
        $cantidad_datos_conciliados=0;
        
        $verificacion1=0;
        $verificacion2=0;
        if($datos_pago_detalle!=null && $datos_venta!=null){
        
        //$result_array = array_intersect_assoc($datos_venta,$datos_pago_detalle);
        //print_r($result_array);
        $max=0;
            foreach ($datos_venta as $itemventa) { 
                if($max<=300){ 
            
                
                $clave = array_search($itemventa['ven_monto'], $datos_pago_detalle, 'pad_total_pagar');
                //print_r($clave);
                $k=0;
                foreach ($datos_pago_detalle as $itempago) {
                    //print("Tama;o del array= ".count($datos_pago_detalle));
                    $validarfecha=$this->validarfechas($itemventa['ven_fecha_transaccion'],$itempago['pad_fecha_transaccion']);
                    if(($itemventa['ven_monto']==$itempago['pad_total_pagar']) || ($this->between($itemventa['ven_monto'],$itempago['pad_total_pagar']) )|| ($this->between($itempago['pad_total_pagar'],$itemventa['ven_monto'])))
                    {
                        $verificacion1=1; //echo $verificacion1;
                        if($itemventa['ven_lote']==$itempago['pad_lote'] && $this->validarautorizacion($itemventa['ven_autorizacion'],$itempago['pad_autorizacion']))
                        {   //print_r("entra en la verificacion de lote y autorizacion");
                            $verificacion2=1; //echo $verificacion2;
                        }
                        else if($itemventa['ven_numero_tc']!=0 && $itemventa['ven_numero_tc']!="0")
                        { //print_r( "si es diferente 1".$itemventa['ven_numero_tc'].' ');
                            //echo $itempago['pad_numero_tarjeta'];
                            $tventa=substr($itemventa['ven_numero_tc'], -4);//echo $tventa;
                            $tpago=substr(rtrim($itempago['pad_numero_tarjeta']), -4); //echo $tpago;
                            if($itempago['pad_numero_tarjeta']!="0")// && $itempago['pad_numero_tarjeta']!="0")
                            {//echo 'entra';
                                if($itemventa['ven_numero_tc']==$itempago['pad_numero_tarjeta'])
                                { //print_r( "num tc venta + num tj pago ");
                                    $verificacion2=1;
                                    //echo 'entra2';
                                }
                                if(strval($tventa)==strval($tpago)){
                                    //echo 'si1';
                                    if(strval($itemventa['ven_lote'])==strval($itempago['pad_lote']))
                                    {
                                        $verificacion2=1;
                                        //echo 'si2';
                                    }
                                }
                                else
                                {
                                    /*echo $tventa.'--';
                                    echo $tpago.'--';
                                    echo $itemventa['ven_lote'].'/n';
                                    echo $itempago['pad_lote'].'/n';*/
                                }
                            }
                            else
                            {
                                //echo 'no rs diferebte';
                            }
                            
                        }
                        /*else if($validarfecha==true && $itemventa['ven_lote']==$itempago['pad_lote'])             COMPARA EL LOTE Y LA FECHA DE TRANSACCION, COMPRUEBA HASTA 2 DIAS MAS A LA VENTA
                        {
                            $verificacion2=1;
                        }*/
                    }
                    
                    
                    
                    
                    if($verificacion1==1 && $verificacion2==1 && (($itemventa['ven_monto']==$itempago['pad_total_pagar']) || ($this->between($itemventa['ven_monto'],$itempago['pad_total_pagar']) )|| ($this->between($itempago['pad_total_pagar'],$itemventa['ven_monto']))))
                    {   
                        //print_r('verificacion 1 '.$verificacion1);
                        //print_r('verificacion 2 '.$verificacion2);
                        $max++;
                        $verificacion1=0;
                        $verificacion2=0;
                        //print_r('entra');
                        $descuento_comision_venta=0;
                        $porcentaje_venta=0;
                        //print_r($itemventa['ven_monto'].'---'.$itempago['pad_cuenta_contable_banco'].'---'.$itemventa['ven_id_banco'].'---'.$itemventa['ven_id_tarjeta_credito'].'---'.$itemventa['ven_tipo_credito'].'---'.$itemventa['ven_cuotas'].'---'.$itemventa['ven_mes_gracia'].'</br>');
                        
                        $porcentaje_venta=$this->porcentaje_comision($itempago['pad_cuenta_contable_banco'],$itemventa['ven_id_banco'],$itemventa['ven_id_tarjeta_credito'],$itemventa['ven_tipo_credito'],$itemventa['ven_cuotas'],$itemventa['ven_mes_gracia']);

                        if(empty($porcentaje_venta['data'][0]['rbt_porcentaje_comision'])){print_r('entra2  ');
                            $porcentaje_venta['data'][0]['rbt_frecuencia_pago']=0; 
                        }

                        $frecuencia_pago=0;
                        if(!empty($porcentaje_venta['data'][0]['rbt_frecuencia_pago'])){
                            $frecuencia_pago=$porcentaje_venta['data'][0]['rbt_frecuencia_pago'];print_r('entra3');
                        }else{
                            $frecuencia_pago=0;print_r('entra4');
                        }

                        //print_r($porcentaje_venta);

                        $porcentaje_final=0;
                    ///COMPARA QUE LA FECHA DE HOY ESTE ENTRE LAS FECHAS DE FERIADO
                        foreach ($porcentaje_venta['data'] as $value) {
                            if($value['rbt_fecha_desde']!=null && $value['rbt_fecha_desde']!=null){
                                if($value['rbt_fecha_hasta']!='0000-00-00' && $value['rbt_fecha_hasta']!='0000-00-00'){
                                    $fecha_hoy = date('Y-m-d');
                                    if($fecha_hoy>=  $value['rbt_fecha_desde']  &&  $fecha_hoy<=  $value['rbt_fecha_hasta']  ){
                                        $porcentaje_final=$value['rbt_porcentaje_feriado'];echo 'entra porcentaje con feriado';
                                    }

                                }
                            }
                        }
                    /// SI NO HAY FERIADO ENTONCES:  BUSCAMOS EL PORCENTAJE SIN FECHA
                        if(empty($porcentaje_final)){
                            foreach ($porcentaje_venta['data'] as $value) {
                                if($value['rbt_fecha_desde']==null && $value['rbt_fecha_desde']==null){
                                    if($value['rbt_fecha_hasta']=='0000-00-00' && $value['rbt_fecha_hasta']=='0000-00-00'){

                                        if($value['rbt_meses_gracia']!=0){
                                            $porcentaje_final=3.50;
                                        }else{
                                            $porcentaje_final=$value['rbt_porcentaje_comision']; echo 'entra porcentaje sin feriado';
                                        }
                                    }
                                }
                            }
                        }
                        if(empty($porcentaje_final)){
                            $porcentaje_final=$porcentaje_venta['data'][0]['rbt_porcentaje_comision'];
                        }


                        $porcentaje_venta=$porcentaje_final;



                        $descuento_comision_venta=($itemventa['ven_monto'])*$porcentaje_venta/100;
                        $descuento_comision_venta=number_format($descuento_comision_venta, 2, '.', '');

                        $valor_diferencia_pago=0;
                        $valor_diferencia_pago=($itempago['pad_descuento_comision']);
                        $valor_diferencia_pago=number_format($valor_diferencia_pago, 2, '.', '');
                        
                        $diferencia=$itempago['pad_total_pagar']-$itemventa['ven_monto']; //PAGOS - VENTAS (valor positivo pago es mayor, valor negativo venta es mayor)
                        $validacion='F';
                        if( $diferencia==0 ||($diferencia<=0.02 && $diferencia >=-0.02) ){

                            $validacion='V';
                            
                        }
                        //echo 'Validacion '.$validacion.'---';
                        $valor_diferencia_pago=$diferencia;

                        $fecha_cruce=date('Y-m-d H:i:s');
                        $numero_conciliacion= $this->ingresar_pagos_ventas('',$fecha_cruce,$itempago['pad_total_pagar'],$itempago['pad_porcentaje_comision'],$itempago['pad_descuento_comision'],$itemventa['ven_monto'],$porcentaje_venta,$descuento_comision_venta,$valor_diferencia_pago,$validacion,$frecuencia_pago);    

                        $this->agregar_fechacruce_pago_detalle($itempago['pad_id'],$fecha_cruce);
                        $this->ingresar_datos_pagos_ventas($numero_conciliacion, $itemventa['ven_id'], $itempago['pad_id']);
                        $this->conciliar_pago_detalle($itempago['pad_id']);
                        $this->conciliar_venta($itemventa['ven_id']);   
                        $cantidad_datos_conciliados=$cantidad_datos_conciliados+1;
                        unset($datos_pago_detalle[$k]);
                        $datos_pago_detalle=array_values($datos_pago_detalle);
                        //$k++;
                        break; 

                   }
                    $verificacion1=0;
                    $verificacion2=0;
                    $k++;
                }  
                
            
                
            }else{$session->setFlashdata('mensaje_bueno', 'Datos conciliados: '.$cantidad_datos_conciliados);
            return redirect()->to(base_url('conciliacion'));}}
            $session->setFlashdata('mensaje_bueno', 'Datos conciliados: '.$cantidad_datos_conciliados);
            return redirect()->to(base_url('conciliacion'));
        }else{ 
            $session->setFlashdata('mensaje_malo', 'Existió un error, por favor vuelva a ejecutar el filtro');
            return redirect()->to(base_url('conciliacion'));}
    }

    public function enviar_conciliacion($data){

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => array(
                    'Content-type: application/json',
                    'Authorization: rapidito-int;N4RaVsn|&BaXLTIk]1',
                ),
                'content' => json_encode($data)
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents('https://int.api.megaprofer.com/api/save/conciliation', false, $contexto);
        $resultado=json_decode($resultado,true); 

        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }
    }

    public function agregar_fechacruce_pago_detalle($pad_id,$pad_fecha_cruce){
        $datos_post = http_build_query(
            array(
                "pad_fecha_cruce"=>$pad_fecha_cruce,                
                "pad_id"=>$pad_id,      
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'agregarfechacruce', false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }


    }


    public function agregar_referencia_contable($rpv_id,$rpv_referencia_contable){
        $datos_post = http_build_query(
            array(
                "rpv_referencia_contable"=>$rpv_referencia_contable,                
                "rpv_id"=>$rpv_id,      
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'relacionpagosventasreferenciacontable', false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }


    }

    public function ingresar_pagos_ventas($rpv_referencia_contable, $rpv_fecha_cruce, $rpv_valor_pago, $rpv_porcentaje_comision_pago, $rpv_descuento_comision_pago,$rpv_valor_venta, $rpv_porcentaje_comision_venta, $rpv_descuento_comision_venta,$rpv_valor_diferencia_pago,$rpv_estado,$rpv_frecuencia_pago){
        $datos_post = http_build_query(
            array(
                "rpv_referencia_contable"=>$rpv_referencia_contable,                
                "rpv_fecha_cruce"=>$rpv_fecha_cruce,
                "rpv_valor_pago"=>$rpv_valor_pago,
                "rpv_porcentaje_comision_pago"=>$rpv_porcentaje_comision_pago,
                "rpv_descuento_comision_pago"=>$rpv_descuento_comision_pago,
                "rpv_valor_venta"=>$rpv_valor_venta,
                "rpv_porcentaje_comision_venta"=>$rpv_porcentaje_comision_venta,
                "rpv_descuento_comision_venta"=>$rpv_descuento_comision_venta,
                "rpv_valor_diferencia_pago"=>$rpv_valor_diferencia_pago,
                "rpv_frecuencia_pago"=>$rpv_frecuencia_pago,
                "rpv_estado"=>$rpv_estado,
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'relacionpagosventascreate', false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado['data']['rpv_id'];
        }else{
            return null;
        }

    }
    public function conciliar_pago_detalle($pad_id){       
        $opciones = array('http' =>
            array(
                'method'  => 'GET',
                'header'  => 'Content-type: application/x-www-form-urlencoded'
            )
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'pagodetalleconciliado/'.$pad_id, false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }

    }
    public function conciliar_venta($ven_id){       
        $opciones = array('http' =>
            array(
                'method'  => 'GET',
                'header'  => 'Content-type: application/x-www-form-urlencoded'
            )
        );
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'ventaconciliado/'.$ven_id, false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }

    }
    public function ingresar_datos_pagos_ventas($rpv_id, $ven_id, $pad_id){
        $datos_post = http_build_query(
            array(
                "rpv_id"=> $rpv_id,
                "ven_id"=> $ven_id,
                "pad_id"=> $pad_id,
                "dpv_estado"=> 1,  
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'datospagosventas', false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }

    }
    public function array_ingresar_datos_pagos_ventas($numero_conciliacion,$array_venta,$array_pago){


        for ($i=0; $i < sizeof($array_venta)  ; $i++) {             
            $this->ingresar_datos_pagos_ventas($numero_conciliacion, $array_venta[$i]['ven_id'], $array_pago[0]['pad_id']);
        }


        
    }

    public function conciliacionmanual(){echo 'CONCILIACION MANUAL';
        $session = \Config\Services::session();
        $contador=1;
        if(empty($session->get('fullName')) && empty($session->get('referenceId')) ){
            return redirect()->to(base_url());
        }
        if(!empty($_POST["tabla_dato_venta"]) && !empty($_POST["tabla_dato_pago"])){

            $valor_tabla_venta = $_POST["tabla_dato_venta"]; 
            

            $valor_tabla_venta=json_decode($valor_tabla_venta,true);

            $valor_tabla_pago = $_POST["tabla_dato_pago"];
            $valor_tabla_pago=json_decode($valor_tabla_pago,true);
            $ven_monto_total=0;
            $pad_monto_depositado_total=0;
            $itempago=[];
            
            $array_venta=[];
            $h_ValorCuentaClientesTarjetaCredito=0;
            foreach ($valor_tabla_venta as $item) {                
                array_push($array_venta,$item);                
                $ven_monto_total=$ven_monto_total+$item['ven_monto'];
            }
            
            //print_r($array_venta);
            
            foreach ($valor_tabla_pago as $item) {                
                array_push($itempago,$item);     
                $pad_monto_depositado_total=$pad_monto_depositado_total+$item['pad_total_pagar'];
                $h_ValorCuentaClientesTarjetaCredito=$h_ValorCuentaClientesTarjetaCredito+$item['pad_monto_depositado']+$item['pad_retencion_iva']+$item['pad_descuento_comision']+$item['pad_retencion_fuente'];

            }//print_r($itempago);
            
            /*if(sizeof($itempago)>1){

                $session->setFlashdata('mensaje_malo', 'Seleccione un solo pago');
                return redirect()->to(base_url('conciliacion'));
            }*/

            

            $comprar_banco=$array_venta[0]['ven_id_banco'];
            foreach ($array_venta as  $value) {

                /*if($comprar_banco!=$value['ven_id_banco']){           COMPARA EL BANCO DE COBROS Y PAGOS
                    $session->setFlashdata('mensaje_malo', 'Necesitan ser del mismo banco');
                    return redirect()->to(base_url('conciliacion'));
                }*/
            }
            

            
            if($ven_monto_total==$pad_monto_depositado_total || $this->between($ven_monto_total,$pad_monto_depositado_total) || $this->between($pad_monto_depositado_total,$ven_monto_total)  ){
                foreach ($array_venta as $itemventa) {
                    foreach ($valor_tabla_pago as $item) {  
                    echo 'entra';

                    $descuento_comision_venta=0;
                    $porcentaje_venta=0;

                    $porcentaje_venta=$this->porcentaje_comision($item['pad_cuenta_contable_banco'],$itemventa['ven_id_banco'],$itemventa['ven_id_tarjeta_credito'],$itemventa['ven_tipo_credito'],$itemventa['ven_cuotas'],$itemventa['ven_mes_gracia']);


                    

                    if(empty($porcentaje_venta['data'][0]['rbt_porcentaje_comision'])){
                        $porcentaje_venta['data'][0]['rbt_porcentaje_comision']=0; 
                    }

                    $frecuencia_pago=0;
                    if(!empty($porcentaje_venta['data'][0]['rbt_frecuencia_pago'])){
                        $frecuencia_pago=$porcentaje_venta['data'][0]['rbt_frecuencia_pago'];
                    }else{
                        $frecuencia_pago=0;
                    }



                    $porcentaje_final=0;
                    ///COMPARA QUE LA FECHA DE HOY ESTE ENTRE LAS FECHAS DE FERIADO
                    foreach ($porcentaje_venta['data'] as $value) {
                        if($value['rbt_fecha_desde']!=null && $value['rbt_fecha_desde']!=null){
                            if($value['rbt_fecha_hasta']!='0000-00-00' && $value['rbt_fecha_hasta']!='0000-00-00'){
                                $fecha_hoy = date('Y-m-d');
                                if($fecha_hoy>=  $value['rbt_fecha_desde']  &&  $fecha_hoy<=  $value['rbt_fecha_hasta']  ){
                                    $porcentaje_final=$value['rbt_porcentaje_feriado'];
                                }

                            }
                        }
                    }
                    /// SI NO HAY FERIADO ENTONCES:  BUSCAMOS EL PORCENTAJE SIN FECHA
                    if(empty($porcentaje_final)){
                        foreach ($porcentaje_venta['data'] as $value) {
                            if($value['rbt_fecha_desde']==null && $value['rbt_fecha_desde']==null){
                                if($value['rbt_fecha_hasta']=='0000-00-00' && $value['rbt_fecha_hasta']=='0000-00-00'){
                                    $porcentaje_final=$value['rbt_porcentaje_comision'];
                                }
                            }
                        }
                    }
                    if(empty($porcentaje_final)){
                        if($porcentaje_venta['data'][0]['rbt_porcentaje_comision']!=null)
                        {
                            $porcentaje_final=$porcentaje_venta['data'][0]['rbt_porcentaje_comision'];
                        }
                        else
                        {
                            $porcentaje_final=0;
                        }
                        
                    }
                    
                    //echo $porcentaje_final;
                        
                        
                        
                    $porcentaje_venta=$porcentaje_final;

                    $descuento_comision_venta=($ven_monto_total)*$porcentaje_venta/100;
                    $descuento_comision_venta=number_format($descuento_comision_venta, 2, '.', '');

                    $valor_diferencia_pago=0;
                    $valor_diferencia_pago=( $item['pad_descuento_comision']);
                    $valor_diferencia_pago=number_format($valor_diferencia_pago, 2, '.', '');

                    $diferencia=$pad_monto_depositado_total-$ven_monto_total;
                    $valor_diferencia_pago=$diferencia;
                    $validacion='F';
                    if( $diferencia==0 ||($diferencia<=0.02 && $diferencia >=-0.02) ){

                        $validacion='V';

                    }
                    //echo $validacion;
                    
    
                              

                    $fecha_cruce=date('Y-m-d H:i:s');
                    
                    if($contador==1){
                    $numero_conciliacion= $this->ingresar_pagos_ventas('',$fecha_cruce,$pad_monto_depositado_total,$item['pad_porcentaje_comision'],$item['pad_descuento_comision'],$ven_monto_total,$porcentaje_venta,$descuento_comision_venta,$valor_diferencia_pago,$validacion,$frecuencia_pago);    
                    $contador++;
                    }
                    $this->agregar_fechacruce_pago_detalle($item['pad_id'],$fecha_cruce);
                    $this->ingresar_datos_pagos_ventas($numero_conciliacion, $itemventa['ven_id'], $item['pad_id']);
                    $this->conciliar_pago_detalle($item['pad_id']);
                    $this->conciliar_venta($itemventa['ven_id']);

                }
                }
                $session->setFlashdata('mensaje_bueno', 'Datos conciliados');
                return redirect()->to(base_url('conciliacion'));

            }else{
                $session->setFlashdata('mensaje_malo', 'Los montos son diferentes');
                return redirect()->to(base_url('conciliacion'));
            }

        }else{
            $session->setFlashdata('mensaje_malo', 'Seleccione un pago y varias ventas');
            return redirect()->to(base_url('conciliacion'));
        }
    }
    
    public function array_conciliar($array_venta,$array_pago){

        $this->conciliar_pago_detalle($array_pago[0]['pad_id']);
        for ($i=0; $i < sizeof($array_venta)  ; $i++) {        
            $this->conciliar_venta($array_venta[$i]['ven_id']);
        }
        
    }

    public function array_valor_retenido_renta($array_venta,$array_pago){

        for ($i=0; $i < sizeof($array_venta)  ; $i++) {             
            $salida[]=array(
                'valor'=>$array_pago[0]['pad_retencion_fuente'],
                'centroCosto'=>$array_venta[$i]['ven_centro_costo']
            );
        }
        return $salida;
    }
    public function array_valor_retenido_iva($array_venta,$array_pago){

        for ($i=0; $i < sizeof($array_venta)  ; $i++) {             
            $salida[]=array(
                'valor'=>$array_pago[0]['pad_retencion_iva'],
                'centroCosto'=>$array_venta[$i]['ven_centro_costo']
            );
        }
        return $salida;
    }
    public function array_valor_servicios_bancarios($array_venta,$array_pago){

        for ($i=0; $i < sizeof($array_venta)  ; $i++) {             
           $salida[]=array(
            'valor'=>$array_pago[0]['pad_descuento_comision'],
            'centroCosto'=>$array_venta[$i]['ven_centro_costo']
        );
       }
       return $salida;
   }

   public function array_conciliacion($porcentaje_venta,$array_venta,$array_pago,$numero_conciliacion){


    for ($i=0; $i < sizeof($array_venta)  ; $i++) {  

        $validacion='F';
        if(!empty($porcentaje_venta)){    

            $numero=($porcentaje_venta * $array_venta[$i]['ven_monto'])/100;
            $numero=number_format($numero, 2, '.', '');
            if($array_pago[0]['pad_descuento_comision']==$numero){
                $validacion='V';
            }else{
                $validacion='F';
            }
        }     
        $salida[]=array(            
            'conciliacionId'=>$array_pago[0]['pad_id'],
            'numeroConciliacion'=>$numero_conciliacion,
            'identificadorVenta'=>$array_venta[$i]['ven_codigo'], 
            'identificadorPago'=>$array_pago[0]['pad_id'],
            'tipoConciliacion'=>'Manual',
            'fechaPago'=>date('Y-m-d H:i:s',strtotime($array_pago[0]['pad_fecha_pago'])),
            'fechaVenta'=>date('Y-m-d H:i:s',strtotime($array_pago[0]['pad_fecha_transaccion'])),
            'montoVoucher'=>$array_venta[$i]['ven_monto'],
            'montoPago'=>$array_pago[0]['pad_total_pagar'],
            'montoRetencionIva'=>$array_pago[0]['pad_retencion_iva'],
            'montoRetencionRenta'=>$array_pago[0]['pad_retencion_fuente'],
            'montoComision'=>$array_pago[0]['pad_descuento_comision'],
            'lote'=>$array_pago[0]['pad_lote'],
            'validacion'=>$validacion,
        );
    }        
    return $salida;
}

public function desconciliar(){
    $session = \Config\Services::session();
    if(!empty($this->request->getPost('numeroconciliacion'))){
        $numeroconciliacion=$this->request->getPost('numeroconciliacion');
        
        $resultado = $this->comprobarnumeroconciliacion($numeroconciliacion); //print_r($resultado);
        $resultado1=false;
        if(empty($resultado['data'][0]['rpv_id'])){
            $session->setFlashdata('mensaje_malo', 'No existe el n��mero de conciliación');
            return redirect()->to(base_url('conciliacion'));
        }
        else
        {
            $opciones = array('http' =>
                array(
                    'method'  => 'POST',
                    'header'  => 'Content-type: application/x-www-form-urlencoded',

                )
            );

            $contexto = stream_context_create($opciones);
            $resultadofechacierre = file_get_contents($this->url_api_conciliacion.'fechamaximacierremes', false, $contexto);
            $resultadofechacierre=json_decode($resultadofechacierre,true);
            
            if(!empty($resultadofechacierre['data'])){
                $fechamaximacierremes=$resultadofechacierre['data'];
                
            }else{
                $fechamaximacierremes=null;
                
            }
            if($fechamaximacierremes!=null && $fechamaximacierremes<$resultado['data'][0]['ven_fecha_transaccion']){
                for($i=0;$i<count($resultado['data']);$i++)
                {
                    
                    $confirmaciondesconciliacion=true;
                    if($confirmaciondesconciliacion == true){
                        $resultado1 = $this->borrardatos($resultado['data'][$i]['rpv_id']);   
                        print_r($resultado1);
                    }else{
                        $session->setFlashdata('mensaje_malo', 'Megaprofer No desconciliado');
                        return redirect()->to(base_url('conciliacion'));
                    }
                }
                if($resultado1==true){
                    $session->setFlashdata('mensaje_bueno', 'Desconciliado');
                    return redirect()->to(base_url('conciliacion'));
                }else{
                    $session->setFlashdata('mensaje_malo', 'No desconciliado');
                    return redirect()->to(base_url('conciliacion'));
                }
            }
            else
            {
                $session->setFlashdata('mensaje_malo', 'No desconciliado, está intentando desconciliar una venta perteneciente a un mes cerrado');
                return redirect()->to(base_url('conciliacion'));
            }

        }
        
    }
}

public function desconciliarFechaCruce(){
    $session = \Config\Services::session();
    echo $this->request->getPost('fechaconciliacion').'iuytfd';
    if(!empty($this->request->getPost('fechaconciliacion'))){
        $numeroconciliacion=$this->request->getPost('fechaconciliacion');
        
        $resultado = $this->comprobarnumeroconciliacionFechaCruce($numeroconciliacion); //print_r($resultado);
        $resultado1=false;
        if(empty($resultado['data'][0]['rpv_id'])){
            $session->setFlashdata('mensaje_malo', 'No existen datos con esa fecha de cruce');
            return redirect()->to(base_url('conciliacion'));
        }
        else
        {
            $opciones = array('http' =>
                array(
                    'method'  => 'POST',
                    'header'  => 'Content-type: application/x-www-form-urlencoded',

                )
            );

            $contexto = stream_context_create($opciones);
            $resultadofechacierre = file_get_contents($this->url_api_conciliacion.'fechamaximacierremes', false, $contexto);
            $resultadofechacierre=json_decode($resultadofechacierre,true);
            
            if(!empty($resultadofechacierre['data'])){
                $fechamaximacierremes=$resultadofechacierre['data'];
                
            }else{
                $fechamaximacierremes=null;
                
            }
            echo '<pre>';
            print_r($resultado);
            echo '</pre>';
            echo $fechamaximacierremes; echo $resultado['data'][0]['ven_fecha_transaccion'];
            if($fechamaximacierremes!=null && $fechamaximacierremes<$resultado['data'][0]['ven_fecha_transaccion']){
                for($i=0;$i<count($resultado['data']);$i++)
                {
                    
                    $confirmaciondesconciliacion=true;
                    if($confirmaciondesconciliacion == true){
                        $resultado1 = $this->borrardatos($resultado['data'][$i]['rpv_id']);   
                        print_r($resultado1);
                    }else{
                        $session->setFlashdata('mensaje_malo', 'Megaprofer No desconciliado');
                        return redirect()->to(base_url('conciliacion'));
                    }
                }
                if($resultado1==true){
                    $session->setFlashdata('mensaje_bueno', 'Desconciliado');
                    return redirect()->to(base_url('conciliacion'));
                }else{
                    $session->setFlashdata('mensaje_malo', 'No desconciliado');
                    return redirect()->to(base_url('conciliacion'));
                }
            }
            else
            {
               $session->setFlashdata('mensaje_malo', 'No desconciliado, está intentando desconciliar una venta perteneciente a un mes cerrado');
               return redirect()->to(base_url('conciliacion'));
            }

        }
        
    }
}

public function borrardatos($rpv_id){
    $datos_post = http_build_query(
        array(
            "rpv_id"=> $rpv_id,
        )
    );

    $opciones = array('http' =>
        array(
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => $datos_post
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado= file_get_contents($this->url_api_conciliacion.'datospagosventassegunnumeroconciliacion', false, $contexto);
    $resultado=json_decode($resultado,true);
    if(!empty($resultado['data'])){
        foreach ($resultado['data'] as $value) {
            $this->datodesconciliarpago($value['pad_id']);
            $this->datodesconciliarventa($value['ven_id']);
        }
    }


    $datos_post = http_build_query(
        array(
            "rpv_id"=> $rpv_id,

        )
    );

    $opciones = array('http' =>
        array(
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => $datos_post
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado = file_get_contents($this->url_api_conciliacion.'relacionpagosventasborrar', false, $contexto);
    $resultado=json_decode($resultado,true); 

    $datos_post = http_build_query(
        array(
            "rpv_id"=> $rpv_id,
        )
    );

    $opciones = array('http' =>
        array(
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => $datos_post
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado1 = file_get_contents($this->url_api_conciliacion.'datospagosventaseliminar', false, $contexto);
    $resultado1=json_decode($resultado1,true);

    if(!empty($resultado) && !empty($resultado1)){
        if($resultado['code']==200 && $resultado1['code']==200){
            return true;
        }else{
            return false;
        }
    }else{
        return false;
    }
}
public function datodesconciliarpago($pad_id){        

    $opciones = array('http' =>
        array(
            'method'  => 'GET',
            'header'  => 'Content-type: application/x-www-form-urlencoded',        
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado= file_get_contents($this->url_api_conciliacion.'pagodetalledesconciliado/'.$pad_id, false, $contexto);
    $resultado=json_decode($resultado,true);

    if(!empty($resultado) ){
        return $resultado;
    }else{
        return null;
    }
}
public function datodesconciliarventa($ven_id){        

    $opciones = array('http' =>
        array(
            'method'  => 'GET',
            'header'  => 'Content-type: application/x-www-form-urlencoded',        
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado= file_get_contents($this->url_api_conciliacion.'ventadesconciliado/'.$ven_id, false, $contexto);
    $resultado=json_decode($resultado,true);

    if(!empty($resultado) ){
        return $resultado;
    }else{
        return null;
    }
}
public function comprobarnumeroconciliacion($rpv_id){        

    $datos_post = http_build_query(
        array(
            "rpv_id"=> $rpv_id,
        )
    );

    $opciones = array('http' =>
        array(
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => $datos_post
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado= file_get_contents($this->url_api_conciliacion.'relacionpagosventascomprobar', false, $contexto);
    $resultado=json_decode($resultado,true);

    if(!empty($resultado) ){
        return $resultado;
    }else{
        return null;
    }
}

public function comprobarnumeroconciliacionFechaCruce($rpv_fecha_cruce){        

    $datos_post = http_build_query(
        array(
            "rpv_fecha_cruce"=> $rpv_fecha_cruce,
        )
    );

    $opciones = array('http' =>
        array(
            'method'  => 'POST',
            'header'  => 'Content-type: application/x-www-form-urlencoded',
            'content' => $datos_post
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado= file_get_contents($this->url_api_conciliacion.'relacionpagosventascomprobarfechacruce', false, $contexto);
    $resultado=json_decode($resultado,true);

    if(!empty($resultado) ){
        return $resultado;
    }else{
        return null;
    }
}

public function VerConciliacion(){        
    
    $session = \Config\Services::session();
    if(!empty($this->request->getPost('numeroconciliacion'))){
        $numeroconciliacion=$this->request->getPost('numeroconciliacion');
        $datos_post = http_build_query(
            array(
                "rpv_id"=> $numeroconciliacion,
            )
        );
    
        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );
    
        $contexto = stream_context_create($opciones);
        $resultado= file_get_contents($this->url_api_conciliacion.'relacionpagosventasverconciliacion', false, $contexto);
        $resultado=json_decode($resultado,true);
    
        if(!empty($resultado) ){
            return $resultado;
        }else{
            return null;
        }
    }
}






public function tarjeta_credito(){
    echo "tarjeta credito";
    $updatedDate ='2021-01-01';

    $opciones = array('http' =>
        array(
            'method'  => 'GET',
            'header'  => array(
                'Content-type: application/x-www-form-urlencoded',
                'Authorization: rapidito-int;N4RaVsn|&BaXLTIk]1',
            ),         
        )
    );

    $contexto = stream_context_create($opciones);
    $resultado = file_get_contents('https://int.api.megaprofer.com/api/bankCard?updatedDate='.$updatedDate, false, $contexto);
    $resultado=json_decode($resultado,true);
    foreach ($resultado as $value) {
        $datos_post = http_build_query(
            array(
                "tac_codigo"=> $value['referenceId'],
                "tac_nombre"=> $value['name'],
                "ban_id"=> $value['bankReference'],
                "tac_estado"=> 1,
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado1 = file_get_contents('http://localhost/conciliacion/public/tarjetacredito', false, $contexto);
        $resultado1=json_decode($resultado1,true); 
        echo '<pre>'; print_r($resultado1); echo '</pre>';

    }
}

public function tipos_cuentas(){
    echo "tipos cuentas";
    //$updatedDate ='2021-01-01';

    $opciones = array('http' =>
        array(
            'method'  => 'GET',
            'header'  => array(
                'Content-type: application/x-www-form-urlencoded',
                'Authorization: rapidito-int;N4RaVsn|&BaXLTIk]1',
            ),         
        )
    );

    $contexto = stream_context_create($opciones);
    //$resultado = file_get_contents('https://int.api.megaprofer.com/api/acctAccount?updatedDate='.$updatedDate, false, $contexto);
    $resultado = file_get_contents('https://int.api.megaprofer.com/api/reportLedgerAccount', false, $contexto);
    $resultado=json_decode($resultado,true);
    foreach ($resultado as $value) {
        $datos_post = http_build_query(
            array(
                "tcu_codigo"=> $value['ledgerAccountNumber'],
                "tcu_descripcion"=> $value['ledgerAccountDescription'],
                "tcu_tipo"=> $value['systemOrigen'],
                "tcu_fecha_modificacion"=> date("Y-m-d", strtotime($value['createDateMessage'])),
                "tcu_estado"=> 1,
            )
        );

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado1 = file_get_contents('http://localhost/conciliacion/public/tipocuenta', false, $contexto);
        $resultado1=json_decode($resultado1,true); 
        echo '<pre>'; print_r($resultado1); echo '</pre>';

    }
}


    public function enviar_asiento_contable(){

    return;
    $datos = array(
        'CabeceraId'=>'1',
        'FechaConciliacion'=>'2021-03-05',
        'Usuario'=>'cbejarano',
        'D_idCargoBanco'=>'15',
        'D_DetalleBanco'=>'Autro 18025502',
        'D_ValorBanco'=> '1586.63',
        'D_idCargoRetencionRenta'=>'20',
        'D_DetalleRetencionRenta'=>'Impuesto Retenido Renta',
        'D_ValorRetenidoRenta'=>array(
            ['Valor'=>'10.70', 'CentroCosto'=>'278'],
            ['Valor'=>'10.70', 'CentroCosto'=>'278'],
        ),
        'D_idCargoRetencionIva'=>'20',
        'D_DetalleRetencionIva'=>'Impuesto Renta Iva',
        'D_ValorRetenidoIva'=>array(
            ['valor'=>'7.75' , 'CentroCosto'=>'278'],
            ['Valor'=>'10', 'CentroCosto'=>'278'],
        ),
        'D_idGastoServiciosBancarios'=>'20',
        'D_DetalleGastosServiciosBancarios'=>'Impuesto retenido renta',
        'D_ValorServiciosBancarios'=>array(
            ['valor'=>'13.33' , 'CentroCosto'=>'278'],
            ['Valor'=>'40', 'CentroCosto'=>'278'],
        ),
        'H_idCargoCuentaClientesTarjetaCredito'=>'Cliente Tarjeta Credito',
        'H_DetalleCuentaClientesTarjetaCredito'=>'11201006',
        'H_ValorCuentaClientesTarjetaCredito'=>'1666.41',
        'Conciliacion'=>array(
            'ConciliacionId'=>'1',
            'NumeroConciliacion'=>'101520',
            'IdentificadorVenta'=>'29',
            'IdentificadorPago'=>'59',
            'TipoConciliacion'=>'Automatica',
            'FechaPago'=>'2021-03-01',
            'FechaVenta'=>'2021-02-15',
            'MontoVoucher'=>'1666.41',
            'MontoPago'=>'1566.63',
            'MontoRetencionIva'=>'17.75',
            'MontoRetencionRenta'=>'28.70',
            'MontoComision'=>'53.33',
            'Lote'=>'25656',
            'Validacion'=>'V',
        ),
    );
    $datos=json_encode($datos);
    echo '<pre>'; print_r($datos); echo '</pre>';
    return;
        /*
        $datos=json_encode($datos);
        echo '<pre>'; print_r($datos); echo '</pre>';
        return; */
        /*
        $datos_post = http_build_query(
            array(
                'FechaConciliacion'=>'2021-03-05',
                'Usuario'=>'cbejarano',
                'D_idCargoBanco'=>'15',
                'D_DetalleBanco'=>'Autro 18025502',
                'D_ValorBanco'=> '1586.63',
                'D_idCargoRetencionRenta'=>'20',
                'D_DetalleRetencionRenta'=>'Impuesto Retenido Renta',
                'D_ValorRetenidoRenta'=>array(
                    ['Valor'=>'10.70', 'CentroCosto'=>'278'],
                    ['Valor'=>'10.70', 'CentroCosto'=>'278'],
                ),
                'D_idCargoRetencionIva'=>'20',
                'D_DetalleRetencionIva'=>'Impuesto Renta Iva',
                'D_ValorRetenidoIva'=>array(
                    ['valor'=>'7.75' , 'CentroCosto'=>'278'],
                    ['Valor'=>'10', 'CentroCosto'=>'278'],
                ),
                'D_idGastoServiciosBancarios'=>'20',
                'D_DetalleGastosServiciosBancarios'=>'Impuesto retenido renta',
                'D_ValorServiciosBancarios'=>array(
                    ['valor'=>'13.33' , 'CentroCosto'=>'278'],
                    ['Valor'=>'40', 'CentroCosto'=>'278'],
                ),
                'H_idCargoCuentaClientesTarjetaCredito'=>'Cliente Tarjeta Credito',
                'H_DetalleCuentaClientesTarjetaCredito'=>'11201006',
                'H_ValorCuentaClientesTarjetaCredito'=>'1666.41',
                'Conciliacion'=>array(
                'ConciliacionId'=>'1',
                'NumeroConciliacion'=>'101520',
                'IdentificadorVenta'=>'29',
                'IdentificadorPago'=>'59',
                'TipoConciliacion'=>'Automatica',
                'FechaPago'=>'2021-03-01',
                'FechaVenta'=>'2021-02-15',
                'MontoVoucher'=>'1666.41',
                'MontoPago'=>'1566.63',
                'MontoRetencionIva'=>'17.75',
                'MontoRetencionRenta'=>'28.70',
                'MontoComision'=>'53.33',
                'Lote'=>'25656',
                'Validacion'=>'V',
                ),
            )
        );*/
        

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => array(
                    'Content-type: application/json',
                    'Authorization: rapidito-int;N4RaVsn|&BaXLTIk]1',
                ),
                'content' => json_encode($datos),
            )
        );
        
        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents('https://int.api.megaprofer.com/api/save/conciliation', false, $contexto);
        $resultado=json_decode($resultado,true); 
        echo '<pre>'; print_r($resultado); echo '</pre>';
    }

    public function enviar_reverso_asiento_contable($numero_conciliacion){

        $opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => array(
                    'Content-type: application/x-www-form-urlencoded',
                    'Authorization: rapidito-int;N4RaVsn|&BaXLTIk]1',
                ),                
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents('https://int.api.megaprofer.com/api/void/conciliation?referenceId='.$numero_conciliacion, false, $contexto);
        $resultado=json_decode($resultado,true); 
        if(!empty($resultado)){
            return $resultado;
        }else{
            return null;
        }

    }
    
    
    public function obtenervalor(){


        if(!empty($this->request->getPost('dato'))){
            $valor=$this->request->getPost('dato');
            $retornar=unserialize(base64_decode($valor));
            echo json_encode($retornar);
        }else{
            echo json_encode([]);
        }
        
    }

    
    
    public function editarObservacion(){
		$session = \Config\Services::session();
		$ven_id = $_POST["editarvenid"];		
		$ven_observacion = $_POST["editarobservacionventa"];	
		
		$datos_post = http_build_query(
			array(
				"ven_observacion"=> $ven_observacion,
				"ven_id"=> $ven_id,
			)
		);

		$opciones = array('http' =>
			array(
				'method'  => 'POST',	
				'header'  => 'Content-type: application/x-www-form-urlencoded',
				'content' => $datos_post
			)
		);

		$contexto = stream_context_create($opciones); print_r($contexto);
		$resultado = file_get_contents($this->url_api_conciliacion.'ventasupdateobservacion', false, $contexto); 
		$resultado=json_decode($resultado,true); 
		if(!empty($resultado)){
			if($resultado['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Observación agregada  con exito');
				return redirect()->to(base_url('Conciliacion')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de editar');
				return redirect()->to(base_url('Conciliacion')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			//return redirect()->to(base_url('TipoPago')); 
		} 
	}
	
	public function editarObservacionPago(){
		$session = \Config\Services::session();
		$pad_id = $_POST["editarpadid"];		
		$pad_observacion = $_POST["editarobservacionpago"];	
		
		$datos_post = http_build_query(
			array(
				"pad_observacion"=> $pad_observacion,
				"pad_id"=> $pad_id,
			)
		);

		$opciones = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $datos_post
            )
        );

        $contexto = stream_context_create($opciones);
        $resultado = file_get_contents($this->url_api_conciliacion.'pagoupdateobservacion', false, $contexto);
        $resultado_pago_detalle=json_decode($resultado,true);print_r($resultado);
		if(!empty($resultado_pago_detalle)){
			if($resultado_pago_detalle['code'] ==200){
				$session->setFlashdata('mensaje_bueno', 'Observación agregada  con exito');
				return redirect()->to(base_url('Conciliacion')); 
			}else{
				$session->setFlashdata('mensaje_malo', 'Fallo, al momento de editar');
				return redirect()->to(base_url('Conciliacion')); 
			}

		}else{
			$session->setFlashdata('mensaje_malo', 'respuesta nula');
			return redirect()->to(base_url('TipoPago')); 
		} 
	}

}