<script>
const baseUrl = '<?= base_url(); ?>';
    let detallesVenta = []; // Array para almacenar los detalles de la compra
    let valotTotal1=0;
function detalleC(){
    let cantidad = document.getElementById('cantidad').value;
    if(cantidad!=''&&cantidad!=0){
        event.preventDefault(); // Evita que se recargue la página
    
        // Obtener los valores de los campos
        
        let producto = document.getElementById('producto').options[document.getElementById('producto').selectedIndex].text;
        let vunitario = document.getElementById('vunitario').value;
        let vtotal = document.getElementById('vtotald').value;
        let id=document.getElementById('producto').value;
    
        // Crear un objeto con los valores obtenidos
        let detalle = {
            cantidad: cantidad,
            producto: producto,
            vunitario: vunitario,
            vtotal: vtotal,
            id:id
        };
    
        // Agregar el objeto al array
        detallesVenta.push(detalle);
    
        // Llamar a la función para actualizar la tabla
        actualizarTabla();
        document.getElementById('cantidad').value='';
    }else{
        alert("Cantidad no puede ser 0");
    }
}


function valorTotal() {
    let cantidad = document.getElementById('cantidad').value;
    let vunitario = document.getElementById('vunitario').value;
    let total=cantidad*vunitario;
    document.getElementById('vtotald').value=total;
   
}

function actualizarTabla() {
    let tabla = document.getElementById('tablaDetalle').getElementsByTagName('tbody')[0];
    tabla.innerHTML = '';
    let descuentosTotales = 0; // Acumulador para el descuento total
    let totalGeneral = 0; // Acumulador para el total general de la tabla

    // Promesas para manejar todas las solicitudes
    const promesas = detallesVenta.map((detalle) => {
        return fetch(`${baseUrl}/Productos/obtenerPrecioProducto/${detalle.id}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Error al obtener el precio del producto');
                }
                return response.json();
            })
            .then(data => {
                const precioGuardado = parseFloat(data.His_PrecioVenta || 0);
                detalle.descuento = (precioGuardado - detalle.vunitario) * detalle.cantidad;
                descuentosTotales += detalle.descuento;

                // Asegrate de que detalle.vtotal sea un nmero
                const vtotal = parseFloat(detalle.vtotal || 0);
                totalGeneral += vtotal;

                const row = `
                    <tr>
                        <td>${detalle.id}</td>
                        <td>${detalle.cantidad}</td>
                        <td>${detalle.producto}</td>
                        <td>${'$' + parseFloat(detalle.vunitario).toFixed(2)}</td>
                        <td>${'$' + vtotal.toFixed(2)}</td>
                        <td>${'$' + detalle.descuento.toFixed(2)}</td>
                    </tr>`;
                tabla.innerHTML += row;
            })
            .catch(error => console.error('Error al obtener el precio:', error));
    });

    // Esperar a que todas las promesas se completen antes de actualizar totales
    Promise.all(promesas).then(() => {
        document.getElementById('detalleVenta').value = JSON.stringify(detallesVenta);
        document.getElementById('vdescuento').value = descuentosTotales.toFixed(2); // Actualiza el total de descuentos
        document.getElementById('vtotalgeneral').value = totalGeneral.toFixed(2); // Actualiza el total general
    });
}




document.addEventListener('DOMContentLoaded', function () {
        // Manejar clic en los botones de expansin
        document.querySelectorAll('.toggle-details').forEach(button => {
            button.addEventListener('click', function () {
                const ventaId = this.getAttribute('data-id');
                const detailsRow = document.getElementById(`details-${ventaId}`);

                if (detailsRow.style.display === 'none') {
                    detailsRow.style.display = 'table-row';
                    this.textContent = '-'; // Cambiar el botn a "-"
                } else {
                    detailsRow.style.display = 'none';
                    this.textContent = '+'; // Cambiar el botn a "+"
                }
            });
        });
        const envioGratisCheckbox = document.getElementById('envioGratis');
        const vnacionalInput = document.getElementById('vnacional');
    
        // Manejar el evento de cambio en el checkbox
        envioGratisCheckbox.addEventListener('change', function () {
            if (this.checked) {
                //vnacionalInput.value = 0; // Establecer el valor a 0
                //vnacionalInput.disabled = true; // Bloquear el campo
            } else {
                vnacionalInput.disabled = false; // Desbloquear el campo si se desactiva el checkbox
            }
        });
    });
</script>