<div class="container-fluid content-inner pb-4">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <!-- Cabecera -->
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Proveedores</h4>
                    <a href="#" class="btn btn-primary btn-icon" data-bs-toggle="modal" data-bs-target="#nuevoProveedor">
                        <i class="btn-inner">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                            </svg>
                        </i>
                        <span class="d-none d-md-inline">Nuevo Proveedor</span>
                    </a>
                </div>

                <!-- Cuerpo -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="proveedores" class="table table-striped table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Nombre</th>
                                    <th>URL</th>
                                    <th>Email</th>
                                    <th>Teléfono</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($proveedores as $p): ?>
                                    <tr>
                                        <td><?= $p['Prv_Nombre']; ?></td>
                                        <td>
                                            <a href="<?= $p['Prv_Url']; ?>" target="_blank"><?= $p['Prv_Url']; ?></a>
                                        </td>
                                        <td><?= $p['Prv_CorreoElectronico']; ?></td>
                                        <td><?= $p['Prv_Telefono']; ?></td>
                                        <td>
                                            <button class="btn btn-outline-primary btn-sm" onclick="editProveedor(
                                                <?= $p['Prv_Id']; ?>,
                                                '<?= addslashes($p['Prv_Nombre']); ?>',
                                                '<?= addslashes($p['Prv_Url']); ?>',
                                                '<?= addslashes($p['Prv_CorreoElectronico']); ?>',
                                                '<?= addslashes($p['Prv_Telefono']); ?>'
                                            )" data-bs-toggle="modal" data-bs-target="#editProveedor">
                                                <i class="bi bi-pencil-square"></i> Editar
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <th>Nombre</th>
                                    <th>URL</th>
                                    <th>Email</th>
                                    <th>Teléfono</th>
                                    <th>Acciones</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Nuevo Proveedor -->
<div class="modal fade" id="nuevoProveedor" data-bs-backdrop="static" tabindex="-1" aria-labelledby="nuevoProveedorLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form action="proveedores/create" method="post">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="nuevoProveedorLabel">Nuevo Proveedor</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="url" class="form-label">URL</label>
                        <input type="url" class="form-control" id="url" name="url">
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label for="telefono" class="form-label">Teléfono</label>
                        <input type="text" class="form-control" id="telefono" name="telefono" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Guardar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Modal: Editar Proveedor -->
<div class="modal fade" id="editProveedor" data-bs-backdrop="static" tabindex="-1" aria-labelledby="editProveedorLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form action="proveedores/edit" method="post">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="editProveedorLabel">Editar Proveedor</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="editnombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="editnombre" name="editnombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="editurl" class="form-label">URL</label>
                        <input type="url" class="form-control" id="editurl" name="editurl">
                    </div>
                    <div class="mb-3">
                        <label for="editemail" class="form-label">Email</label>
                        <input type="email" class="form-control" id="editemail" name="editemail" required>
                    </div>
                    <div class="mb-3">
                        <label for="edittelefono" class="form-label">Teléfono</label>
                        <input type="text" class="form-control" id="edittelefono" name="edittelefono" required>
                    </div>
                    <input type="hidden" id="editid" name="editid">
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Guardar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>
