<?php
namespace App\Models;
use CodeIgniter\Model;
class TipoPagoExternoModel extends Model
{
    protected $table = 'TipoPagoExterno';
    protected $primaryKey = 'Tpe_Id';

    // Campos permitidos para operaciones de inserción o actualización
    protected $allowedFields = [
        'Tpe_Nombre', 
        'Tpe_Numero', 
        'Tpe_Estado'
    ];

    protected $useTimestamps = false; // Si no tienes campos created_at/updated_at, esto queda en false
    protected $returnType    = 'array'; // Devuelve resultados como array

    // Validaciones (opcional)
    protected $validationRules = [
        'Tpe_Nombre' => 'required|string|max_length[255]',
        'Tpe_Numero' => 'required|integer',
        'Tpe_Estado' => 'required|integer'
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    // CRUD Methods
    public function getAll()
    {
        return $this->findAll();
    }

    public function getById($id)
    {
        return $this->find($id);
    }

    public function create($data)
    {
        return $this->insert($data);
    }

    public function updateById($id, $data)
    {
        return $this->update($id, $data);
    }

    public function deleteById($id)
    {
        return $this->delete($id);
    }
}
?>
