<?php
namespace App\Models;
use CodeIgniter\Model;
class ProveedoresModel extends Model {
   protected $table = 'Proveedores';
    protected $primaryKey = 'Prv_Id'; // Cambia esto según el nombre de tu clave primaria
    protected $allowedFields = [
        'Prv_Nombre', 'Prv_Telefono', 'Prv_CorreoElectronico', 'Prv_Url'
        // Añade otros campos permitidos aquí
    ];



    public function get_all_providers() {
        $query = $this->db->get('Proveedores');
        return $query->result_array();
    }

    public function get_provider($id) {
        $query = $this->db->get_where('Proveedores', array('Prv_Id' => $id));
        return $query->row_array();
    }

    public function insert_provider($data) {
        return $this->db->insert('Proveedores', $data);
    }

    public function update_provider($id, $data) {
        $this->db->where('Prv_Id', $id);
        return $this->db->update('Proveedores', $data);
    }

    public function delete_provider($id) {
        $this->db->where('Prv_Id', $id);
        return $this->db->delete('Proveedores');
    }
}
?>
