<?php
namespace App\Models;
use CodeIgniter\Model;
class ProductosModel extends Model {
   protected $table = 'Productos';
    protected $primaryKey = 'Pro_Id'; // Cambia esto según el nombre de tu clave primaria
    protected $allowedFields = [
        'Pro_Nombre', 'Pro_Descripcion', 'Pro_PrecioCompra', 'Pro_PrecioVenta','Pro_Stock','Pro_StockMinimo'
        // Añade otros campos permitidos aquí
    ];



    public function get_all_providers() {
        $query = $this->db->get('Productos');
        return $query->result_array();
    }

    public function get_provider($id) {
        $query = $this->db->get_where('Productos', array('Pro_Id' => $id));
        return $query->row_array();
    }

    public function insert_provider($data) {
        return $this->db->insert('Productos', $data);
    }

    public function update_provider($id, $data) {
        $this->db->where('Pro_Id', $id);
        return $this->db->update('Productos', $data);
    }

    public function delete_provider($id) {
        $this->db->where('Pro_Id', $id);
        return $this->db->delete('Productos');
    }
}
?>
