<?php
namespace App\Models;

use CodeIgniter\Model;

class KardexInventarioModel extends Model
{
    protected $table = 'KardexInventario';
    protected $primaryKey = 'Kar_Id';
    protected $allowedFields = [
        'Pro_Id', 
        'Kar_TipoTransaccion', 
        'Kar_Cantidad', 
        'Kar_PrecioUnitario', 
        'Kar_ValorTotal', 
        'Kar_FechaTransaccion', 
        'Usu_Id', 
        'Cod_Id', 
        'Kar_SaldoRestante', 
        'Kar_ValorTransaccion', 
        'Kar_ValorEnvio', 
        'Kar_PrecioVentaProducto', 
        'Pre_Id'
    ];

    /**
     * Registrar movimiento en el Kardex
     */
    public function registrarMovimiento($kardexData)
    {
        if (!$this->insert($kardexData)) {
            return ['error' => $this->errors()];
        }
        return ['success' => true];
    }

    /**
     * Actualizar o insertar en Inventario
     */
    public function actualizarInventario($proId, $cantidad)
    {
        $db = \Config\Database::connect();
        $inventarioTable = $db->table('Inventario');

        // Obtener inventario actual
        $inventario = $inventarioTable->where('Pro_Id', $proId)->get()->getRow();

        if ($inventario) {
            // Actualizar cantidad
            $nuevaCantidad = $inventario->Inv_Cantidad + $cantidad;

            $inventarioTable->where('Pro_Id', $proId)->update([
                'Inv_Cantidad' => $nuevaCantidad,
                'Inv_Actualizado' => date('Y-m-d H:i:s'),
            ]);
        } else {
            // Insertar nuevo registro
            $inventarioTable->insert([
                'Pro_Id' => $proId,
                'Inv_Cantidad' => $cantidad,
                'Inv_Actualizado' => date('Y-m-d H:i:s'),
            ]);
        }
    }
    
    
}
?>