<?php
namespace App\Models;
use CodeIgniter\Model;
class ComprasModel extends Model {
   protected $table = 'ComprasCabecera';
    protected $primaryKey = 'Com_Id'; // Cambia esto según el nombre de tu clave primaria
    protected $allowedFields = [
        'Com_Id', 'Prv_Id', 'Com_FechaCompra', 'Com_ValorTotal', 'Com_ValorEnvioNacional', 'Com_ValorEnvioInternacional', 'Com_NumeroPedido', 'Tpi_Id'
        // Añade otros campos permitidos aquí
    ];



   public function get_all_compras() {
    $builder = $this->db->table('ComprasCabecera');
    $builder->select('
        ComprasCabecera.Com_Id,Productos.Pro_Nombre,
        ComprasCabecera.Com_FechaCompra,
        ComprasCabecera.Com_ValorTotal,
        ComprasCabecera.Com_NumeroPedido,
        Proveedores.Prv_Nombre,
        ComprasDetalle.Pro_Id,
        ComprasDetalle.Cod_Cantidad AS CantidadComprada,
        IFNULL(SUM(RecepcionProductos.Rec_Cantidad), 0) AS CantidadRecibida,
        (ComprasDetalle.Cod_Cantidad - IFNULL(SUM(RecepcionProductos.Rec_Cantidad), 0)) AS CantidadPendiente
    ');
    $builder->join('Proveedores', 'Proveedores.Prv_Id = ComprasCabecera.Prv_Id', 'inner');
    $builder->join('ComprasDetalle', 'ComprasDetalle.Com_Id = ComprasCabecera.Com_Id', 'inner');
    $builder->join('RecepcionProductos', 'RecepcionProductos.Pro_Id = ComprasDetalle.Pro_Id AND RecepcionProductos.Com_Id = ComprasCabecera.Com_Id', 'left');
    $builder->join('Productos', 'Productos.Pro_Id = ComprasDetalle.Pro_Id', 'inner');
    $builder->groupBy('ComprasDetalle.Pro_Id, ComprasCabecera.Com_Id');
    $builder->orderBy('ComprasCabecera.Com_FechaCompra', 'DESC');
    $query = $builder->get();

    $result = $query->getResultArray();

    // Reestructurar el resultado para agrupar por compra
    $compras = [];
    foreach ($result as $row) {
        $compraId = $row['Com_Id'];

        if (!isset($compras[$compraId])) {
            // Inicializa la compra con sus datos básicos
            $compras[$compraId] = [
                'Com_Id' => $row['Com_Id'],
                'Com_FechaCompra' => $row['Com_FechaCompra'],
                'Com_ValorTotal' => $row['Com_ValorTotal'],
                'Com_NumeroPedido' => $row['Com_NumeroPedido'],
                'Prv_Nombre' => $row['Prv_Nombre'],
                'detalles' => [], // Inicializa los detalles como un array vacío
            ];
        }

        // Agrega los detalles del producto a la compra correspondiente
        $compras[$compraId]['detalles'][] = [
            'Pro_Id' => $row['Pro_Nombre'],
            'CantidadComprada' => $row['CantidadComprada'],
            'CantidadRecibida' => $row['CantidadRecibida'],
            'CantidadPendiente' => $row['CantidadPendiente'],
        ];
    }

    return $compras;
}


    public function get_compras($id) {
        $query = $this->db->get_where('ComprasCabecera', array('Com_Id' => $id));
        return $query->row_array();
    }

    public function insert_compras($data) {
        return $this->db->insert('ComprasCabecera', $data);
    }

    public function update_compras($id, $data) {
        $this->db->where('Com_Id', $id);
        return $this->db->update('ComprasCabecera', $data);
    }

    public function delete_compras($id) {
        $this->db->where('Com_Id', $id);
        return $this->db->delete('ComprasCabecera');
    }
}
?>
