<?php
namespace App\Models;
use CodeIgniter\Model;
class ClientesModel extends Model {
   protected $table = 'Clientes';
    protected $primaryKey = 'Cli_Id'; // Cambia esto según el nombre de tu clave primaria
    protected $allowedFields = [
        'Cli_Nombre','Cli_Celular','Cli_Observacion','Ciu_Id','Cli_Contacto','Cli_Embajador','Cli_PrecioEspecial'
        // Añade otros campos permitidos aquí
    ];

    public function getClientesWithCiudades()
    {
        return $this->select('Clientes.*, Ciudades.*, GROUP_CONCAT(ClienteHijos.Clh_Nombre SEPARATOR ", ") as hijos')
                    ->join('Ciudades', 'Ciudades.Ciu_Id = Clientes.Ciu_Id', 'inner') // Inner join para ciudades
                    ->join('ClienteHijos', 'ClienteHijos.Cli_Id = Clientes.Cli_Id', 'left') // Left join para hijos
                    ->groupBy('Clientes.Cli_Id') // Agrupar por Cliente para que GROUP_CONCAT funcione correctamente
                    ->orderBy('Clientes.Cli_Nombre')
                    ->findAll();
    }

}
?>
