<?php
namespace App\Controllers;

use App\Models\VentasModel;
use App\Models\ProductosModel;
use App\Models\ClientesModel;
use CodeIgniter\Controller;

class Reportes extends Controller {
    protected $ventasModel;
    protected $productosModel;
    protected $clientesModel;

    public function __construct() {
        $this->ventasModel = new VentasModel();
        $this->clientesModel = new ClientesModel();
        $this->productosModel = new ProductosModel();
    }
    public function alertarClientes() {
        $clientes = $this->ventasModel->obtenerClientesAlerta();
        $data['clientes'] = $clientes;
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("reportes/reporteAlertaClientes", $data);
        echo view("layouts/footer");
    }
    public function ventasPorProducto() {
        $producto_id = $this->request->getGet('producto_id');
        $fecha_inicio = $this->request->getGet('fecha_inicio');
        $fecha_fin = $this->request->getGet('fecha_fin');

        $data['productos'] = $this->productosModel->findAll();
        $data['ventas'] = [];

        if ($producto_id && $fecha_inicio && $fecha_fin) {
            $data['ventas'] = $this->ventasModel->obtenerVentasPorProducto($producto_id, $fecha_inicio, $fecha_fin);
        }
        
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("reportes/reporteVentasProducto", $data);
        echo view("layouts/footer");
        
    }
    public function ventasPorCliente() {
        $cliente_id = $this->request->getGet('cliente_id');

        $data['clientes'] = $this->clientesModel->findAll();
        $data['ventas'] = [];

        if ($cliente_id) {
            $data['ventas'] = $this->ventasModel->obtenerVentasPorCliente($cliente_id);
        }
        
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("reportes/reporteVentasCliente", $data);
        echo view("layouts/footer");
        
    }
}
?>