<?php
namespace App\Controllers;

use App\Models\VentasModel;
use CodeIgniter\Controller;

class Estadisticas extends Controller {
    protected $ventasModel;

    public function __construct() {
        $this->ventasModel = new VentasModel();
    }

    public function index() {
        $data['ventas_mes'] = $this->ventasModel->obtener_ventas_por_mes();
        $data['ventas_productos'] = $this->ventasModel->obtener_ventas_por_producto();
        $data['ventas_productos_mes'] = $this->ventasModel->obtener_ventas_productos_por_mes();
        $data['formulas_por_mes'] = $this->ventasModel->obtener_formulas_por_mes();
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("reportes/reporteEstadisticas", $data);
        echo view("layouts/footer");
    }
}
?>