<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\DashboardModel;

class Dashboard extends Controller
{
    public function index()
    {
        $model = new DashboardModel();

        $data = [
            'totalVentas' => $model->getTotalVentas(),
            'totalCompras' => $model->getTotalCompras(),
            'stockTotal' => $model->getStockTotal(),
            'productosCriticos' => $model->getProductosCriticos(),
            'margenGanancia' => $model->getMargenGanancia(),
            'productoMasVendido' => $model->getProductoMasVendido(),
        ];
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("home/list", $data);
        echo view("layouts/footer");
        echo view("compras/scripts");
    }
}
