<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\ClientesModel;
use App\Models\ClienteHijosModel;
use App\Models\CiudadesModel;

class Clientes extends Controller
{
    protected $clientesModel;
    protected $clienteHijosModel;
    protected $ciudadesModel;

    public function __construct()
    {
        $this->clientesModel = new ClientesModel();
        $this->clienteHijosModel = new ClienteHijosModel();
        $this->ciudadesModel = new CiudadesModel();
    }

    public function index()
    {
        $data['clientes'] = $this->clientesModel->getClientesWithCiudades();
        $data['ciudades'] = $this->ciudadesModel->findAll();
        $data['hijos'] = $this->clienteHijosModel->findAll();
        
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("clientes/list", $data);
        echo view("layouts/footer");
        echo view("clientes/scripts");
    }

    public function view($id)
    {
        $data['clientes'] = $this->clientesModel->get_product($id);
        if (empty($data['clientes'])) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Cliente no encontrado: ' . $id);
        }
        echo view('clientes/view', $data);
    }

    public function create()
    {
        helper('form');
        $data = [];

        if ($this->request->getMethod() === 'post' && $this->validate([
            'nombre' => 'required',
        ])) {
            $saveData = [
                'Cli_Nombre' => $this->request->getPost('nombre'),
                'Cli_Celular' => $this->request->getPost('celular'),
                'Cli_Observacion' => $this->request->getPost('observacion'),
                'Ciu_Id' => $this->request->getPost('ciudad'),
                'Cli_Contacto' => $this->request->getPost('contacto'),
                'Cli_Embajador' => $this->request->getPost('tipo'),
                'Cli_PrecioEspecial' => $this->request->getPost('precio'),
            ];

            if ($this->clientesModel->save($saveData)) {
                return redirect()->to('/clientes');
            } else {
                $data['error'] = 'Error al guardar los datos.';
            }
        }

        return redirect()->to('/clientes');
    }

    public function edit()
    {
        $id = $this->request->getPost('editid');
        $data['clientes'] = $this->clientesModel->find($id);

        if (empty($data['clientes'])) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Cliente no encontrado: ' . $id);
        }

        helper('form');

        if ($this->request->getMethod() === 'post' && $this->validate([
            'editnombre' => 'required',
        ])) {
            $this->clientesModel->update($id, [
                'Cli_Nombre' => $this->request->getPost('editnombre'),
                'Cli_Celular' => $this->request->getPost('editcelular'),
                'Cli_Observacion' => $this->request->getPost('editobservacion'),
                'Ciu_Id' => $this->request->getPost('editciudad'),
                'Cli_Contacto' => $this->request->getPost('editcontacto'),
                'Cli_Embajador' => $this->request->getPost('edittipo'),
                'Cli_PrecioEspecial' => $this->request->getPost('editprecio'),
            ]);
            return redirect()->to('/clientes');
        } else {
            echo view('clientes/edit', $data);
        }
    }

    public function createHijo()
    {
        helper('form');
        $data = [];

        if ($this->request->getMethod() === 'post' && $this->validate([
            'nombrehijo' => 'required',
            'cliid' => 'required',
        ])) {
            $saveData = [
                'Clh_Nombre' => $this->request->getPost('nombrehijo'),
                'Clh_FechaNacimiento' => $this->request->getPost('fecha'),
                'Clh_Genero' => $this->request->getPost('genero'),
                'Clh_Observaciones' => $this->request->getPost('observacionhijo'),
                'Cli_Id' => $this->request->getPost('cliid'),
            ];
            print_r($saveData);

            if ($this->clienteHijosModel->save($saveData)) {
                return redirect()->to('/clientes');
            } else {
                $data['error'] = 'Error al guardar los datos.';
            }
        }

        return redirect()->to('/clientes');
    }

    public function editHijo()
    {
        $id = $this->request->getPost('editidhijo');
        $data['hijo'] = $this->clienteHijosModel->find($id);

        if (empty($data['hijo'])) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Hijo no encontrado: ' . $id);
        }

        helper('form');

        if ($this->request->getMethod() === 'post' && $this->validate([
            'editnombrehijo' => 'required',
        ])) {
            $this->clienteHijosModel->update($id, [
                'Clh_Nombre' => $this->request->getPost('editnombrehijo'),
                'Clh_FechaNacimiento' => $this->request->getPost('editfecha'),
                'Clh_Genero' => $this->request->getPost('editgenero'),
                'Clh_Observaciones' => $this->request->getPost('editobservacionhijo'),
            ]);
            return redirect()->to('/clientes');
        } else {
            echo view('clientes/editHijo', $data);
        }
    }

    public function hijosCliente()
    {
        $id = $this->request->getPost('id');
        $local = new \App\Models\ClienteHijosModel();
        $data['hijos'] = $local->getHijosbyCliId($id);
        return $this->response->setJSON($data); // Esto enviará la respuesta en formato JSON
    }

    public function delete($id)
    {
        $this->clienteHijosModel->delete($id);
        return redirect()->to('/clientes');
    }
}
?>