$(document).ready(function () {
    if (document.getElementById("pagina").value == 1) {
        llenarMatriz();
    }
    llenarSelects();
    confirmarEnvio();
});


function llenarMatriz() {
    $.ajax({
        type: "get",
        url: "getMatriz",
        data: null,
        success: function (response) {
            tabla = "<thead>";
            tabla += "<tr><th colspan='14' style='text-align: center'></th>";
            tabla += "<th colspan='6' style='text-align: center'>Aporte a función sustantiva</th>";
            tabla += "<th colspan='9' style='text-align: center'>Indicador</th>";
            tabla += "<th colspan='2' style='text-align: center'></th></tr>";
            tabla += "<tr><th scope='col' style='text-align: center'>No.</th>";
            tabla += "<th scope='col' style='text-align: center'>Sede</th>";
            tabla += "<th scope='col' style='text-align: center'>Código de carrera</th>";
            tabla += "<th scope='col' style='text-align: center'>Código de convenio internacional</th>";
            tabla += "<th scope='col' style='text-align: center'>Nombre del convenio / convocatoria / evento internacional</th>";
            tabla += "<th scope='col' style='text-align: center'>Contraparte internacional</th>";
            tabla += "<th scope='col' style='text-align: center'>País</th>";
            tabla += "<th scope='col' style='text-align: center'>Tipo del movilizado participante / ejecutor</th>";
            tabla += "<th scope='col' style='text-align: center'>Apellido(s) del movilizado / participante / ejecutor</th>";
            tabla += "<th scope='col' style='text-align: center'>Nombre(s) del movilizado / participante / ejecutor</th>";
            tabla += "<th scope='col' style='text-align: center'>Actividades</th>";
            tabla += "<th scope='col' style='text-align: center'>Fecha de inicio</th>";
            tabla += "<th scope='col' style='text-align: center'>Fecha de finalización</th>";
            tabla += "<th scope='col' style='text-align: center'>Área de conocimiento</th>";
            tabla += "<th scope='col' style='text-align: center'>Financiamiento</th>";
            tabla += "<th scope='col' style='text-align: center'>Docencia</th>";
            tabla += "<th scope='col' style='text-align: center'>Investigación</th>";
            tabla += "<th scope='col' style='text-align: center'>Vinculación</th>";
            tabla += "<th scope='col' style='text-align: center'>Desarrollo docente / administrativo</th>";
            tabla += "<th scope='col' style='text-align: center'>Internacionalización</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 1 Mov. Est. Entr.</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 2 Mov. Est. Salien.</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 3 Mov. Doc. Entr.</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 4 Mov. Doc. Salie.</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 5 Mov. Adm. Salie.</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 6 Convenio Efect.</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 7 Prod. Científic.</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 8 Inter. Currículo (COIL, IDV, Telecolaboración)</th>";
            tabla += "<th scope='col' style='text-align: center'>Opción 9 Inter. en casa (Interculturalidad en el campus)</th>";
            tabla += "<th scope='col' style='text-align: center'>Evidencia</th>";
            tabla += "<th scope='col' style='text-align: center'>Acción</th>";
            tabla += "<tbody>";

            for (let index = 0; index < response.length; index++) {
                tabla += "<tr>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_ID'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['SED_SEDE'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['ICAR_CODIGO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_CONV_CODIGO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_CONV_NOMBRE'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_CONTRAPARTE'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['PAI_PAIS'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['PTIP_TIPO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_PAPELLIDO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_PNOMBRE'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_ACTIVIDADES'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_FINICIO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_FFIN'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['ARE_CODIGO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['FIN_TIPO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_ADOCENCIA'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_AINVESTIGACION'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_AVINCULACION'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_AADMINISTRATIVO'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_AINTERNACIONALIZACION'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_1'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_2'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_3'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_4'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_5'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_6'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_7'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_8'] + "</td>";
                tabla += "<td style='text-align: center'>" + response[index]['INTER_INDICADOR_9'] + "</td>";
                tabla += "<td style='max-width: 200px; overflow: auto; white-space: normal; overflow-wrap: break-word;'><a href=" + response[index]['INTER_EVIDENCIA'] + " target='_blank'>" + response[index]['INTER_EVIDENCIA'] + "</a></td>";
                tabla += "<td style='text-align: center'><a href='" + base_url + "editar/" + response[index]['INTER_ID'] + "' class='btn btn-primary' type='button'>Editar</a></td>";
            }
            tabla += "</tbody>";
            $('#matriz').html(tabla);

            $('#matriz').DataTable({
                columnDefs: [
                    { visible: true, targets: [0, 1, 4, 8, 9, 11, 12, 30] },
                    { visible: false, targets: '_all' }
                ]
            });
            var table = $('#matriz').DataTable();
            $('.toggle-vis').on('click', function (e) {
                e.preventDefault();
                var column = table.column($(this).data('column'));
                column.visible(!column.visible());
            });
        }
    })
}

function llenarSelects() {
    var $sede = $('#sede');
    var $codigo = $('#codigo');
    var $pais = $('#pais');
    var $tipo = $('#tipo_participante');
    var $area = $('#area');
    var $financiamiento = $('#financiamiento');

    $.ajax({
        type: "post",
        url: "getInformacion",
        data: null,
        success: function (response) {
            for (let index = 0; index < response.sede.length; index++) {
                $sede.append("<option value='" + response.sede[index]['SED_ID'] + "'>" + response.sede[index]['SED_SEDE'] + "</option>");
            }
            for (let index = 0; index < response.codigo.length; index++) {
                $codigo.append("<option value='" + response.codigo[index]['ICAR_ID'] + "'>" + response.codigo[index]['ICAR_CODIGO'] + "</option>");
            }
            for (let index = 0; index < response.pais.length; index++) {
                $pais.append("<option value='" + response.pais[index]['PAI_ID'] + "'>" + response.pais[index]['PAI_PAIS'] + "</option>");
            }
            for (let index = 0; index < response.tipo.length; index++) {
                $tipo.append("<option value='" + response.tipo[index]['PTIP_ID'] + "'>" + response.tipo[index]['PTIP_TIPO'] + "</option>");
            }
            for (let index = 0; index < response.area.length; index++) {
                $area.append("<option value='" + response.area[index]['ARE_ID'] + "'>" + response.area[index]['ARE_CODIGO'] + " (" + response.area[index]['ARE_DESCRIPCION'] + ")</option>");
            }
            for (let index = 0; index < response.financiamiento.length; index++) {
                $financiamiento.append("<option value='" + response.financiamiento[index]['FIN_ID'] + "'>" + response.financiamiento[index]['FIN_TIPO'] + "</option>");
            }
        }
    })
}

function confirmarEnvio() {
    $('#btnEnviar').click(function (event) {
        // Prevent the default form submission behavior
        event.preventDefault();

        // Check if the form is valid
        if (!document.getElementById('formInter').checkValidity()) {
            // If the form is not valid, display validation messages and return false
            document.getElementById('formInter').reportValidity();
            return false;
        }

        // If the form is valid, show the confirmation dialog
        var confirmacion = confirm("¿Está seguro de que desea enviar los datos?");
        if (confirmacion) {
            // If the user confirms, submit the form
            document.getElementById('formInter').submit();
        }
    });
}