<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\Query;

class HomeModel extends Model
{
	public function __construct()
	{
		$this->db = \Config\Database::connect();
	}

	public function getMatriz()
	{
		$sql = 'SELECT 
		tbl_internacionalizacion.INTER_ID,
		tbl_inter_sede.SED_SEDE,
		tbl_inter_carrera.ICAR_CODIGO,
		tbl_internacionalizacion.INTER_CONV_CODIGO,
		tbl_internacionalizacion.INTER_CONV_NOMBRE,
		tbl_internacionalizacion.INTER_CONTRAPARTE,
		tbl_inter_pais.PAI_PAIS,
		tbl_inter_tipo_participante.PTIP_TIPO,
		tbl_internacionalizacion.INTER_PAPELLIDO,
		tbl_internacionalizacion.INTER_PNOMBRE,
		tbl_internacionalizacion.INTER_ACTIVIDADES,
		tbl_internacionalizacion.INTER_FINICIO,
		tbl_internacionalizacion.INTER_FFIN,
		tbl_internacionalizacion.INTER_FINICIO,
		tbl_inter_area_conocimiento.ARE_CODIGO,
		tbl_inter_financiamiento.FIN_TIPO,
		tbl_internacionalizacion.INTER_ADOCENCIA,
		tbl_internacionalizacion.INTER_AINVESTIGACION,
		tbl_internacionalizacion.INTER_AVINCULACION,
		tbl_internacionalizacion.INTER_AADMINISTRATIVO,
		tbl_internacionalizacion.INTER_AINTERNACIONALIZACION,
		tbl_internacionalizacion.INTER_INDICADOR_1,
		tbl_internacionalizacion.INTER_INDICADOR_2,		
		tbl_internacionalizacion.INTER_INDICADOR_3,
		tbl_internacionalizacion.INTER_INDICADOR_4,
		tbl_internacionalizacion.INTER_INDICADOR_5,
		tbl_internacionalizacion.INTER_INDICADOR_6,
		tbl_internacionalizacion.INTER_INDICADOR_7,
		tbl_internacionalizacion.INTER_INDICADOR_8,
		tbl_internacionalizacion.INTER_INDICADOR_9,
		tbl_internacionalizacion.INTER_EVIDENCIA

        FROM tbl_internacionalizacion
        
        INNER JOIN tbl_inter_sede ON tbl_internacionalizacion.SED_ID = tbl_inter_sede.SED_ID
        INNER JOIN tbl_inter_carrera on tbl_internacionalizacion.ICAR_ID = tbl_inter_carrera.ICAR_ID
		INNER JOIN tbl_inter_pais on tbl_internacionalizacion.PAI_ID = tbl_inter_pais.PAI_ID
		INNER JOIN tbl_inter_tipo_participante on tbl_internacionalizacion.PTIP_ID = tbl_inter_tipo_participante.PTIP_ID
		INNER JOIN tbl_inter_area_conocimiento on tbl_internacionalizacion.ARE_ID = tbl_inter_area_conocimiento.ARE_ID
		INNER JOIN tbl_inter_financiamiento on tbl_internacionalizacion.FIN_ID = tbl_inter_financiamiento.FIN_ID
		';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}

	public function getSedes()
	{
		$sql = 'SELECT * FROM `tbl_inter_sede`;';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}

	public function getCodigosCarreras()
	{
		$sql = 'SELECT * FROM `tbl_inter_carrera`;';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}
	public function getPaises()
	{
		$sql = 'SELECT * FROM `tbl_inter_pais`;';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}
	public function getTipoParticipante()
	{
		$sql = 'SELECT * FROM `tbl_inter_tipo_participante`;';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}
	public function getAreaConocimiento()
	{
		$sql = 'SELECT * FROM `tbl_inter_area_conocimiento`;';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}
	public function getFinanciamiento()
	{
		$sql = 'SELECT * FROM `tbl_inter_financiamiento`;';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}
	public function insertInternacionalizacion($datos)
	{
		$this->db->table('tbl_internacionalizacion')->insert($datos);
	}
	public function getInterPorId($id)
	{
		$sql = 'SELECT 
		tbl_internacionalizacion.INTER_ID,
		tbl_inter_sede.SED_ID,
		tbl_inter_sede.SED_SEDE,
		tbl_inter_carrera.ICAR_ID,
		tbl_inter_carrera.ICAR_CODIGO,
		tbl_internacionalizacion.INTER_CONV_CODIGO,
		tbl_internacionalizacion.INTER_CONV_NOMBRE,
		tbl_internacionalizacion.INTER_CONTRAPARTE,
		tbl_inter_pais.PAI_ID,
		tbl_inter_pais.PAI_PAIS,
		tbl_inter_tipo_participante.PTIP_ID,
		tbl_inter_tipo_participante.PTIP_TIPO,
		tbl_internacionalizacion.INTER_PAPELLIDO,
		tbl_internacionalizacion.INTER_PNOMBRE,
		tbl_internacionalizacion.INTER_ACTIVIDADES,
		tbl_internacionalizacion.INTER_FINICIO,
		tbl_internacionalizacion.INTER_FFIN,
		tbl_internacionalizacion.INTER_FINICIO,
		tbl_inter_area_conocimiento.ARE_ID,
		tbl_inter_area_conocimiento.ARE_CODIGO,
		tbl_inter_financiamiento.FIN_ID,
		tbl_inter_financiamiento.FIN_TIPO,
		tbl_internacionalizacion.INTER_ADOCENCIA,
		tbl_internacionalizacion.INTER_AINVESTIGACION,
		tbl_internacionalizacion.INTER_AVINCULACION,
		tbl_internacionalizacion.INTER_AADMINISTRATIVO,
		tbl_internacionalizacion.INTER_AINTERNACIONALIZACION,
		tbl_internacionalizacion.INTER_INDICADOR_1,
		tbl_internacionalizacion.INTER_INDICADOR_2,		
		tbl_internacionalizacion.INTER_INDICADOR_3,
		tbl_internacionalizacion.INTER_INDICADOR_4,
		tbl_internacionalizacion.INTER_INDICADOR_5,
		tbl_internacionalizacion.INTER_INDICADOR_6,
		tbl_internacionalizacion.INTER_INDICADOR_7,
		tbl_internacionalizacion.INTER_INDICADOR_8,
		tbl_internacionalizacion.INTER_INDICADOR_9,
		tbl_internacionalizacion.INTER_EVIDENCIA

        FROM tbl_internacionalizacion
        
        INNER JOIN tbl_inter_sede ON tbl_internacionalizacion.SED_ID = tbl_inter_sede.SED_ID
        INNER JOIN tbl_inter_carrera on tbl_internacionalizacion.ICAR_ID = tbl_inter_carrera.ICAR_ID
		INNER JOIN tbl_inter_pais on tbl_internacionalizacion.PAI_ID = tbl_inter_pais.PAI_ID
		INNER JOIN tbl_inter_tipo_participante on tbl_internacionalizacion.PTIP_ID = tbl_inter_tipo_participante.PTIP_ID
		INNER JOIN tbl_inter_area_conocimiento on tbl_internacionalizacion.ARE_ID = tbl_inter_area_conocimiento.ARE_ID
		INNER JOIN tbl_inter_financiamiento on tbl_internacionalizacion.FIN_ID = tbl_inter_financiamiento.FIN_ID
		WHERE INTER_ID=' . $id . ';';
		$resp = $this->db->query($sql);
		return $resp->getResultArray();
	}
	
	public function updateInternacionalizacion($id, $data)
	{
		$this->db->table('tbl_internacionalizacion')
				 ->where('INTER_ID', $id)
				 ->update($data);
	}
}
