<?php

namespace App\Controllers;

use App\Models\HomeModel;


class Home extends BaseController
{
    protected $homeModel;

    public function __construct()
    {
        $this->homeModel = new HomeModel();
    }
    public function index(): string
    {
        return view('header').view('matriz');
    }
    public function getMatriz()
    {
        $matriz = $this->homeModel->getMatriz();
        return $this->response->setJSON($matriz);
    }
    public function agregar()
    {
        return view('header').view('agregar');
    }
    public function getInformacion()
    {
        $sede = $this->homeModel->getSedes();
        $codigo = $this->homeModel->getCodigosCarreras();
        $pais = $this->homeModel->getPaises();
        $tipo = $this->homeModel->getTipoParticipante();
        $area = $this->homeModel->getAreaConocimiento();
        $financiamiento = $this->homeModel->getFinanciamiento();
        $responseData = [
            'sede' => $sede,
            'codigo' => $codigo,
            'pais' => $pais,
            'tipo' => $tipo,
            'area' => $area,
            'financiamiento' => $financiamiento
        ];

        return $this->response->setJSON($responseData);
    }
    public function insertInternacionalizacion()
    {

        /*
        "INTER_ADOCENCIA" => $_POST['a_docencia'] ?? 0, Si se utiliza INT (1,0) en la base de datos
        "INTER_ADOCENCIA" => $_POST['a_docencia'] ?? '', si se utiliza CHAR (X, "")
         */

        $datos = [
            "SED_ID" => $_POST['sede'],
            "ICAR_ID" => $_POST['codigo'],
            "INTER_CONV_CODIGO" => $_POST['convenio_codigo'],
            "INTER_CONV_NOMBRE" => $_POST['convenio_nombre'],
            "INTER_CONTRAPARTE" => $_POST['contraparte'],
            "PAI_ID" => $_POST['pais'],
            "PTIP_ID" => $_POST['tipo_participante'],
            "INTER_PAPELLIDO" => $_POST['apellido_participante'],
            "INTER_PNOMBRE" => $_POST['nombre_participante'],
            "INTER_ACTIVIDADES" => $_POST['actividades'],
            "INTER_FINICIO" => $_POST['fecha_inicio'],
            "INTER_FFIN" => $_POST['fecha_fin'],
            "ARE_ID" => $_POST['area'],
            "FIN_ID" => $_POST['financiamiento'],
            "INTER_ADOCENCIA" => $_POST['a_docencia'] ?? '',
            "INTER_AINVESTIGACION" => $_POST['a_investigacion'] ?? '',
            "INTER_AVINCULACION" => $_POST['a_vinculacion'] ?? '',
            "INTER_AADMINISTRATIVO" => $_POST['a_administrativo'] ?? '',
            "INTER_AINTERNACIONALIZACION" => $_POST['a_internacionalizacion'] ?? '',
            "INTER_INDICADOR_1" => $_POST['indicador_1'] ?? '',
            "INTER_INDICADOR_2" => $_POST['indicador_2'] ?? '',
            "INTER_INDICADOR_3" => $_POST['indicador_3'] ?? '',
            "INTER_INDICADOR_4" => $_POST['indicador_4'] ?? '',
            "INTER_INDICADOR_5" => $_POST['indicador_5'] ?? '',
            "INTER_INDICADOR_6" => $_POST['indicador_6'] ?? '',
            "INTER_INDICADOR_7" => $_POST['indicador_7'] ?? '',
            "INTER_INDICADOR_8" => $_POST['indicador_8'] ?? '',
            "INTER_INDICADOR_9" => $_POST['indicador_9'] ?? '',
            "INTER_EVIDENCIA" => $_POST['evidencia']
        ];
        $this->homeModel->insertInternacionalizacion($datos);
        echo "<script>alert('Se han ingresado los datos correctamente.'); window.location.href='" . base_url() . "';</script>";
    }
    public function editar(int $id)
    {
        $data['inter'] = $this->homeModel->getInterPorId($id);
        return view('header').view('editar', $data);
    }
    public function updateInternacionalizacion()
    {
        $id = $_POST['inter_id'];
        $datos = [
            "SED_ID" => $_POST['sede'],
            "ICAR_ID" => $_POST['codigo'],
            "INTER_CONV_CODIGO" => $_POST['convenio_codigo'],
            "INTER_CONV_NOMBRE" => $_POST['convenio_nombre'],
            "INTER_CONTRAPARTE" => $_POST['contraparte'],
            "PAI_ID" => $_POST['pais'],
            "PTIP_ID" => $_POST['tipo_participante'],
            "INTER_PAPELLIDO" => $_POST['apellido_participante'],
            "INTER_PNOMBRE" => $_POST['nombre_participante'],
            "INTER_ACTIVIDADES" => $_POST['actividades'],
            "INTER_FINICIO" => $_POST['fecha_inicio'],
            "INTER_FFIN" => $_POST['fecha_fin'],
            "ARE_ID" => $_POST['area'],
            "FIN_ID" => $_POST['financiamiento'],
            "INTER_ADOCENCIA" => $_POST['a_docencia'] ?? '',
            "INTER_AINVESTIGACION" => $_POST['a_investigacion'] ?? '',
            "INTER_AVINCULACION" => $_POST['a_vinculacion'] ?? '',
            "INTER_AADMINISTRATIVO" => $_POST['a_administrativo'] ?? '',
            "INTER_AINTERNACIONALIZACION" => $_POST['a_internacionalizacion'] ?? '',
            "INTER_INDICADOR_1" => $_POST['indicador_1'] ?? '',
            "INTER_INDICADOR_2" => $_POST['indicador_2'] ?? '',
            "INTER_INDICADOR_3" => $_POST['indicador_3'] ?? '',
            "INTER_INDICADOR_4" => $_POST['indicador_4'] ?? '',
            "INTER_INDICADOR_5" => $_POST['indicador_5'] ?? '',
            "INTER_INDICADOR_6" => $_POST['indicador_6'] ?? '',
            "INTER_INDICADOR_7" => $_POST['indicador_7'] ?? '',
            "INTER_INDICADOR_8" => $_POST['indicador_8'] ?? '',
            "INTER_INDICADOR_9" => $_POST['indicador_9'] ?? '',
            "INTER_EVIDENCIA" => $_POST['evidencia']
        ];
        $this->homeModel->updateInternacionalizacion($id, $datos);
        echo "<script>alert('Se han actualizado los datos correctamente.'); window.location.href='" . base_url() . "';</script>";
    }
}
