<div class="container-fluid content-inner pb-4">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <!-- Cabecera -->
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Productos</h4>
                    <a href="#" class="btn btn-primary btn-icon" data-bs-toggle="modal" data-bs-target="#nuevoProducto">
                        <i class="btn-inner">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                            </svg>
                        </i>
                        <span class="d-none d-md-inline">Nuevo Producto</span>
                    </a>
                </div>

                <!-- Cuerpo -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="productos" class="table table-striped table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Nombre</th>
                                    <th>Descripción</th>
                                    <th>Precio Compra</th>
                                    <th>Precio Venta</th>
                                    <th>Stock Actual</th>
                                    <th>Stock Mínimo</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($productos as $p): ?>
                                    <tr>
                                        <td><?= $p['Pro_Nombre']; ?></td>
                                        <td><?= $p['Pro_Descripcion']; ?></td>
                                        <td class="text-end"><?= '$' . number_format($p['Pro_PrecioCompra'], 2, ',', '.'); ?></td>
                                        <td class="text-end"><?= '$' . number_format($p['Pro_PrecioVenta'], 2, ',', '.'); ?></td>
                                        <td class="text-end"><?= $p['Pro_Stock']; ?></td>
                                        <td class="text-end"><?= $p['Pro_StockMinimo']; ?></td>
                                        <td>
                                            <button class="btn btn-outline-primary btn-sm" onclick="editProducto(
                                                <?= $p['Pro_Id']; ?>,
                                                '<?= addslashes($p['Pro_Nombre']); ?>',
                                                '<?= addslashes($p['Pro_Descripcion']); ?>',
                                                <?= $p['Pro_PrecioCompra']; ?>,
                                                <?= $p['Pro_PrecioVenta']; ?>,
                                                <?= $p['Pro_StockMinimo']; ?>
                                            )" data-bs-toggle="modal" data-bs-target="#editProducto">
                                                <i class="bi bi-pencil-square"></i> Editar
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <th>Nombre</th>
                                    <th>Descripción</th>
                                    <th>Precio Compra</th>
                                    <th>Precio Venta</th>
                                    <th>Stock Actual</th>
                                    <th>Stock Mínimo</th>
                                    <th>Acciones</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Nuevo Producto -->
<div class="modal fade" id="nuevoProducto" data-bs-backdrop="static" tabindex="-1" aria-labelledby="nuevoProductoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form action="productos/create" method="post">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="nuevoProductoLabel">Nuevo Producto</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="descripcion" class="form-label">Descripción</label>
                        <input type="text" class="form-control" id="descripcion" name="descripcion">
                    </div>
                    <div class="form-group mb-3">
                        <label for="compra" class="form-label">Precio de Compra</label>
                        <input type="number" class="form-control" id="compra" name="compra" step="0.01" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="venta" class="form-label">Precio de Venta</label>
                        <input type="number" class="form-control" id="venta" name="venta" step="0.01" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="stockminimo" class="form-label">Stock Mínimo</label>
                        <input type="number" class="form-control" id="stockminimo" name="stockminimo" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Guardar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Modal: Editar Producto -->
<div class="modal fade" id="editProducto" data-bs-backdrop="static" tabindex="-1" aria-labelledby="editProductoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form action="productos/edit" method="post">
            <div class="modal-content">
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title" id="editProductoLabel">Editar Producto</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="editnombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="editnombre" name="editnombre" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="editdescripcion" class="form-label">Descripción</label>
                        <input type="text" class="form-control" id="editdescripcion" name="editdescripcion">
                    </div>
                    <div class="form-group mb-3">
                        <label for="editcompra" class="form-label">Precio de Compra</label>
                        <input type="number" class="form-control" id="editcompra" name="editcompra" step="0.01" required>
                    </div>
                    <div class="form-group mb-3">
             
