<!-- application/Views/inventario_dashboard.php -->
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard de Inventario - Sistema HiPP</title>
    <link rel="stylesheet" href="<?= base_url('assets/css/bootstrap.min.css') ?>">
    <style>
        :root {
            --hipp-magenta: #e4007f;
            --hipp-green: #83b22c;
            --hipp-yellow: #f7d23b;
            --hipp-blue: #0fa3b1;
            --hipp-orange: #f36c3d;
            --hipp-white: #ffffff;
        }
        body {
            background-color: var(--hipp-white);
            color: #333;
            font-family: Arial, sans-serif;
        }
        .card {
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        .bg-magenta { background-color: var(--hipp-magenta); color: var(--hipp-white); }
        .bg-green { background-color: var(--hipp-green); color: var(--hipp-white); }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: var(--hipp-magenta);
            color: var(--hipp-white);
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        .critical {
            color: red;
            font-weight: bold;
        }
        .adequate {
            color: green;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center" style="color: var(--hipp-magenta);">Dashboard de Inventario</h1>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header bg-green">
                        <h4 class="card-title">Inventario Detallado</h4>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Producto</th>
                                    <th>Descripción</th>
                                    <th>Stock</th>
                                    <th>Stock Mínimo</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($inventario as $producto): ?>
                                    <tr>
                                        <td><?= $producto['Pro_Id'] ?></td>
                                        <td><?= $producto['Pro_Nombre'] ?></td>
                                        <td><?= $producto['Pro_Descripcion'] ?></td>
                                        <td><?= $producto['Inv_Cantidad'] ?></td>
                                        <td><?= $producto['Pro_StockMinimo'] ?></td>
                                        <td>
                                            <?php if ($producto['Inv_Cantidad'] < $producto['Pro_StockMinimo']): ?>
                                                <span class="critical">Crítico</span>
                                            <?php else: ?>
                                                <span class="adequate">Adecuado</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="<?= base_url('assets/js/bootstrap.bundle.min.js') ?>"></script>
</body>
</html>
