<?php
namespace App\Models;

use CodeIgniter\Model;

class RecepcionProductosModel extends Model
{
    protected $table = 'RecepcionProductos';
    protected $primaryKey = 'Rec_Id';
    protected $allowedFields = ['Com_Id', 'Pro_Id', 'Rec_Cantidad', 'Rec_Fecha'];

    // Método para calcular la cantidad total recibida por producto y compra
    public function getTotalRecibidoPorProducto($compraId, $productoId)
    {
        return $this->selectSum('Rec_Cantidad')
                    ->where('Com_Id', $compraId)
                    ->where('Pro_Id', $productoId)
                    ->get()
                    ->getRowArray();
    }
}
