
               
   <div class="container-fluid content-inner pb-4">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <!-- Cabecera -->
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Ventas</h4>
                    <a href="#" class="btn btn-primary btn-icon" data-bs-toggle="modal" data-bs-target="#nuevaVenta">
                        <i class="btn-inner">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                            </svg>
                        </i>
                        <span class="d-none d-md-inline">Nueva Venta</span>
                    </a>
                </div>

                <!-- Cuerpo -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Acción</th>
                                    <th>Cliente</th>
                                    <th>Fecha</th>
                                    <th>Total</th>
                                    <th>Valor Pago</th>
                                    <th>Descuento</th>
                                    <th>Valor Envío</th>
                                    <th>Tipo Pago</th>
                                    <th>Envío Gratis</th>
                                    <th>Regalo Influencer</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $cont1 = 1; foreach ($ventas as $venta): ?>
                                    <tr>
                                        <td><?= $cont1++; ?></td>
                                        <td>
                                            <button class="btn btn-outline-primary btn-sm toggle-details" onclick="toggleDetalles(<?= $venta['cabecera']['Ven_Id']; ?>)">
                                                <i class="bi bi-eye"></i> Detalles
                                            </button>
                                        </td>
                                        <td><?= $venta['cabecera']['Cli_Id']; ?></td>
                                        <td><?= $venta['cabecera']['Ven_FechaVenta']; ?></td>
                                        <td class="text-end"><?= '$' . number_format($venta['cabecera']['Ven_ValorTotal'], 2); ?></td>
                                        <td class="text-end"><?= '$' . number_format($venta['cabecera']['Ven_TotalPagoCliente'], 2); ?></td>
                                        <td class="text-end"><?= '$' . number_format($venta['cabecera']['Ven_Descuento'], 2); ?></td>
                                        <td class="text-end"><?= '$' . number_format($venta['cabecera']['Ven_ValorEnvioNacional'], 2); ?></td>
                                        <td><?= $venta['cabecera']['Tpe_Id']; ?></td>
                                        <td><?= $venta['cabecera']['Ven_EnvioGratis'] == 0 ? 'No' : 'Sí'; ?></td>
                                        <td><?= $venta['cabecera']['Ven_RegaloInfluencer'] == 0 ? 'No' : 'Sí'; ?></td>
                                    </tr>
                                    <!-- Fila de Detalles -->
                                    <tr id="details-<?= $venta['cabecera']['Ven_Id']; ?>" style="display: none;" class="bg-light">
                                        <td colspan="11">
                                            <div class="p-3">
                                                <h6>Detalles de la Venta</h6>
                                                <table class="table table-bordered table-sm mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Cantidad</th>
                                                            <th>Nombre</th>
                                                            <th>Valor Unitario</th>
                                                            <th>Valor Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $cont2 = 1; foreach ($venta['detalles'] as $detalle): ?>
                                                            <tr>
                                                                <td><?= $cont2++; ?></td>
                                                                <td class="text-center"><?= $detalle['Ved_Cantidad']; ?></td>
                                                                <td><?= $detalle['Pro_Nombre']; ?></td>
                                                                <td class="text-end"><?= '$' . number_format($detalle['Ved_ValorUnitario'], 2); ?></td>
                                                                <td class="text-end"><?= '$' . number_format($detalle['Ved_ValorTotal'], 2); ?></td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleDetalles(ventaId) {
        const detalles = document.getElementById(`details-${ventaId}`);
        detalles.style.display = detalles.style.display === 'none' || detalles.style.display === '' ? 'table-row' : 'none';
    }
</script>

<!-- Modal: Nueva Venta -->

<div class="modal fade" id="nuevaVenta" data-bs-backdrop="static" tabindex="-1" aria-labelledby="nuevaVentaLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <form action="ventas/create" method="post">
            <div class="modal-content">
                <!-- Header del Modal -->
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="nuevaVentaLabel">Registrar Nueva Venta</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>

                <!-- Body del Modal -->
                <div class="modal-body">
                    <div class="row g-4">
                        <!-- Información General -->
                        <div class="col-lg-6">
                            <h6 class="border-bottom pb-2">Información General</h6>
                            <div class="form-group mb-3">
                                <label for="cliente" class="form-label">Cliente</label>
                                <select class="form-select" id="cliente" name="cliente" required>
                                    <option value="">Seleccionar</option>
                                    <?php foreach ($clientes as $cliente): ?>
                                        <option value="<?= $cliente['Cli_Id']; ?>"><?= $cliente['Cli_Nombre']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="fecha" class="form-label">Fecha de Venta</label>
                                <input type="date" class="form-control" id="fecha" name="fecha" required>
                            </div>
                            <div class="form-group mb-3">
                                <label for="tipopago" class="form-label">Tipo de Pago</label>
                                <select class="form-select" id="tipopago" name="tipopago" required>
                                    <option value="">Seleccionar</option>
                                    <?php foreach ($tipopagoe as $t): ?>
                                        <option value="<?= $t['Tpe_Id']; ?>"><?= $t['Tpe_Nombre']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" id="envioGratis" name="envioGratis">
                                <label class="form-check-label" for="envioGratis">Envío Gratis</label>
                            </div>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" id="esRegalo" name="esRegalo">
                                <label class="form-check-label" for="esRegalo">Es un Regalo</label>
                            </div>
                        </div>

                        <!-- Detalle de la Venta -->
                        <div class="col-lg-6">
                            <h6 class="border-bottom pb-2">Detalle de la Venta</h6>
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="cantidad" class="form-label">Cantidad</label>
                                    <input type="number" class="form-control" id="cantidad" name="cantidad" placeholder="0">
                                </div>
                                <div class="col-md-8 mb-3">
                                    <label for="producto" class="form-label">Producto</label>
                                    <select class="form-select" id="producto" name="producto" required>
                                        <option value="">Seleccionar</option>
                                        <?php foreach ($productos as $producto): ?>
                                            <option value="<?= $producto['Pro_Id']; ?>"><?= $producto['Pro_Nombre']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="vunitario" class="form-label">Valor Unitario</label>
                                    <input type="number" class="form-control" id="vunitario" name="vunitario" placeholder="0.00" step="0.01" onchange='valorTotal()'>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="vtotald" class="form-label">Valor Total</label>
                                    <input type="number" class="form-control" id="vtotald" name="vtotald" placeholder="0.00" step="0.01" readonly>
                                </div>
                            </div>
                            <button type="button" class="btn btn-primary btn-sm mb-3" onclick="detalleC()">Agregar Detalle</button>
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered" id="tablaDetalle">
                                    <thead>
                                        <tr class="table-light">
                                            <th>ID</th>
                                            <th>Cantidad</th>
                                            <th>Producto</th>
                                            <th>Valor Unitario</th>
                                            <th>Valor Total</th>
                                            <th>Acción</th>
                                        </tr>
                                    </thead>
                                    <tbody >
                                        <!-- Aquí se llenarán los detalles dinámicamente -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Resumen -->
                    <div class="row g-4 mt-3">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="vtotalgeneral" class="form-label">Valor Total Venta</label>
                                <input type="number" class="form-control" id="vtotalgeneral" name="vtotalgeneral" placeholder="0.00" step="0.01" value="0" readonly>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="vtotalgeneralpago" class="form-label">Total Pago</label>
                                <input type="number" class="form-control" id="vtotalgeneralpago" name="vtotalgeneralpago" placeholder="0.00" step="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="vinternacional" class="form-label">Valor Envío Nacional</label>
                                <input type="number" class="form-control" id="vnacional" name="vnacional" placeholder="0.00" step="0.01" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="vdescuento" class="form-label">Valor de Descuento</label>
                                <input type="number" class="form-control" id="vdescuento" name="vdescuento" placeholder="0.00" step="0.01" value="0" readonly>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer del Modal -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Guardar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
                <input type="hidden" id="detalleVenta" name="detalleVenta">
            </div>
        </form>
    </div>
</div>


    <div class="modal fade" id="editProducto" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <form action="productos/edit" method="post"><div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Modificar producto</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="editnombre" class="form-label">Nombre</label>
                        <input type="text" class="form-control" id="editnombre" name="editnombre" aria-describedby="email" placeholder="">
                    </div>
                    <div class="form-group">
                        <label for="editdescripcion" class="form-label">Descripción</label>
                        <input type="text" class="form-control" id="editdescripcion" name="editdescripcion" aria-describedby="email" placeholder="">
                    </div>
                    <div class="form-group">
                        <label for="editcompra" class="form-label">Precio de compra</label>
                        <input type="text" class="form-control" id="editcompra" name="editcompra" aria-describedby="email" placeholder="">
                    </div>
                    <div class="form-group">
                        <label for="editventa" class="form-label">Precio de venta</label>
                        <input type="text" class="form-control" id="editventa" name="editventa" aria-describedby="email" placeholder="">
                    </div>
                    <div class="form-group">
                        <label for="editstockminimo" class="form-label">Stock mínimo</label>
                        <input type="text" class="form-control" id="editstockminimo" name="editstockminimo" aria-describedby="email" placeholder="">
                    </div>
                    <input type="hidden" class="form-control" id="editid" name="editid" aria-describedby="email" placeholder="">
                    <div class="text-start">
                        <button type="submit" class="btn btn-primary" data-bs-dismiss="modal">Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal" >Cancelar</button>
                    </div>
                </div>
            </div>
        </div></form>
    </div>
    <style>
        .modal-open .container-fluid,
.modal-open .container {
  -webkit-filter: blur(2px);
  -moz-filter: blur(2px);
  -o-filter: blur(2px);
  -ms-filter: blur(2px);
  filter: blur(2px);
}

.bordered-div {
    border: 2px solid black; /* Define el grosor, estilo y color del borde */
    padding: 10px;           /* Espaciado interno dentro del borde */
    margin: 10px;            /* Espaciado externo fuera del borde */
    border-radius: 5px;      /* Hace que las esquinas sean redondeadas */
}

    </style>