<!-- application/Views/dashboard.php -->
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema de Gestión HiPP</title>
    <link rel="stylesheet" href="<?= base_url('assets/css/bootstrap.min.css') ?>">
    <style>
        :root {
            --hipp-magenta: #e4007f;
            --hipp-green: #83b22c;
            --hipp-yellow: #f7d23b;
            --hipp-blue: #0fa3b1;
            --hipp-orange: #f36c3d;
            --hipp-white: #ffffff;
        }
        body {
            background-color: var(--hipp-white);
            color: #333;
            font-family: Arial, sans-serif;
        }
        .card {
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .bg-magenta { background-color: var(--hipp-magenta); color: var(--hipp-white); }
        .bg-green { background-color: var(--hipp-green); color: var(--hipp-white); }
        .bg-yellow { background-color: var(--hipp-yellow); color: #000; }
        .bg-blue { background-color: var(--hipp-blue); color: var(--hipp-white); }
        .bg-orange { background-color: var(--hipp-orange); color: var(--hipp-white); }
        .card-header {
            font-weight: bold;
            font-size: 1.2rem;
        }
        .card-title {
            font-size: 2rem;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="mb-4 text-center" style="color: var(--hipp-magenta);">Dashboard Principal</h1>
        <div class="row">
            <!-- Total Ventas -->
            <div class="col-md-3">
                <div class="card bg-magenta mb-3">
                    <div class="card-header text-black">Ventas del Mes</div>
                    <div class="card-body">
                        <h5 class="card-title">$<?= number_format($totalVentas, 2) ?></h5>
                        <p class="card-text">Total en ventas del mes actual.</p>
                    </div>
                </div>
            </div>
            <!-- Total Compras -->
            <div class="col-md-3">
                <div class="card bg-green mb-3">
                    <div class="card-header text-black">Compras del Mes</div>
                    <div class="card-body">
                        <h5 class="card-title">$<?= number_format($totalCompras, 2) ?></h5>
                        <p class="card-text">Total en compras del mes actual.</p>
                    </div>
                </div>
            </div>
            <!-- Stock Disponible -->
            <div class="col-md-3">
                <div class="card bg-yellow mb-3">
                    <div class="card-header text-black">Stock Disponible</div>
                    <div class="card-body">
                        <h5 class="card-title"><?= $stockTotal ?></h5>
                        <p class="card-text">Productos disponibles en inventario.</p>
                    </div>
                </div>
            </div>
            <!-- Inventario Crítico -->
            <div class="col-md-3">
                <div class="card bg-blue mb-3">
                    <div class="card-header text-black">Inventario Crítico</div>
                    <div class="card-body">
                        <h5 class="card-title"><?= $productosCriticos ?></h5>
                        <p class="card-text">Productos con stock bajo.</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-4">
            <!-- Margen de Ganancia -->
            <div class="col-md-6">
                <div class="card bg-orange mb-3">
                    <div class="card-header text-black">Margen de Ganancia</div>
                    <div class="card-body">
                        <h5 class="card-title"><?= number_format($margenGanancia * 100, 2) ?>%</h5>
                        <p class="card-text">Porcentaje de ganancia mensual.</p>
                    </div>
                </div>
            </div>
            <!-- Producto Más Vendido -->
            <div class="col-md-6">
                <div class="card bg-green mb-3">
                    <div class="card-header text-black">Producto Más Vendido</div>
                    <div class="card-body">
                        <h5 class="card-title"><?= $productoMasVendido['nombre'] ?></h5>
                        <p class="card-text">Cantidad: <?= $productoMasVendido['cantidad'] ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="<?= base_url('assets/js/bootstrap.bundle.min.js') ?>"></script>
</body>
</html>
