
               
    <div class="container-fluid content-inner pb-4">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <!-- Cabecera -->
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">Compras</h4>
                    <a href="#" class="btn btn-primary btn-icon" data-bs-toggle="modal" data-bs-target="#nuevaCompra">
                        <i class="btn-inner">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                            </svg>
                        </i>
                        <span class="d-none d-md-inline">Nueva Compra</span>
                    </a>
                </div>

                <!-- Cuerpo -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Fecha Compra</th>
                                    <th>Proveedor</th>
                                    <th>Valor Total</th>
                                    <th>Número Orden</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($compras as $compra): ?>
                                    <tr>
                                        <td><?= $compra['Com_FechaCompra']; ?></td>
                                        <td><?= $compra['Prv_Nombre']; ?></td>
                                        <td class="text-end"><?= '$' . number_format($compra['Com_ValorTotal'], 2); ?></td>
                                        <td><?= $compra['Com_NumeroPedido']; ?></td>
                                        <td>
                                            <button class="btn btn-outline-primary btn-sm" onclick="toggleDetalles(<?= $compra['Com_Id']; ?>)">
                                                <i class="bi bi-eye"></i> Detalles
                                            </button>
                                            <button class="btn btn-outline-success btn-sm" onclick="cargarDatosRecepcion(<?= $compra['Com_Id']; ?>)" data-bs-toggle="modal" data-bs-target="#modalRecepcion">
                                                <i class="bi bi-box-arrow-in-down"></i> Recepción
                                            </button>
                                        </td>
                                    </tr>
                                    <!-- Fila de Detalles (oculta por defecto) -->
                                    <tr id="detalles-<?= $compra['Com_Id']; ?>" class="bg-light" style="display: none;">
                                        <td colspan="5">
                                            <div class="p-3">
                                                <h6>Detalles de la Compra</h6>
                                                <table class="table table-bordered table-sm">
                                                    <thead>
                                                        <tr>
                                                            <th>Producto</th>
                                                            <th>Cantidad Comprada</th>
                                                            <th>Cantidad Recibida</th>
                                                            <th>Cantidad Pendiente</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($compra['detalles'] as $detalle): ?>
                                                            <tr>
                                                                <td><?= $detalle['Pro_Id']; ?></td>
                                                                <td><?= $detalle['CantidadComprada']; ?></td>
                                                                <td><?= $detalle['CantidadRecibida']; ?></td>
                                                                <td><?= $detalle['CantidadPendiente']; ?></td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleDetalles(compraId) {
        const detalles = document.getElementById(`detalles-${compraId}`);
        if (detalles.style.display === 'none' || detalles.style.display === '') {
            detalles.style.display = 'table-row';
        } else {
            detalles.style.display = 'none';
        }
    }
</script>

    <div class="modal fade" id="nuevaCompra" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <form action="compras/create" method="post"><div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Ingresar compra</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                  
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="nombre" class="form-label">Fecha de compra</label>
                                <input type="date" class="form-control" id="fecha" name="fecha" aria-describedby="email" placeholder="">
                            </div>
                            <div class="form-group">
                                <label for="descripcion" class="form-label">Proveedor</label>
                                <select class="form-control" id="proveedor" name="proveedor" required>
                                    <option value="0">Seleccionar</option>
                                    <?php foreach($proveedores as $p){?>
                                        <option value="<?php echo $p['Prv_Id'];?>"><?php echo $p['Prv_Nombre'];?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="compra" class="form-label">Valor total</label>
                                <input type="number" class="form-control" id="vtotal" name="vtotal"  placeholder="" step="0.01">
                            </div>
                            <div class="form-group">
                                <label for="venta" class="form-label">Valor envío nacional</label>
                                <input type="number" class="form-control" id="vnacional" name="vnacional" placeholder="" step="0.01">
                            </div>
                            <div class="form-group">
                                <label for="venta" class="form-label">Valor envío internacional</label>
                                <input type="number" class="form-control" id="vinternacional" name="vinternacional"  placeholder="" step="0.01">
                            </div>
                            <div class="form-group">
                                <label for="stockminimo" class="form-label">Número de orden</label>
                                <input type="text" class="form-control" id="numeroorden" name="numeroorden" placeholder="">
                            </div>
                            <div class="form-group">
                                <label for="stockminimo" class="form-label">Tipo de pago</label>
                                <select class="form-control" id="tipopago" name="tipopago" required>
                                    <option value="0">Seleccionar</option>
                                    <?php foreach($tipopagoi as $t){?>
                                        <option value="<?php echo $t['Tpi_Id'];?>"><?php echo $t['Tpi_Nombre'];?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <h6>Detalle de la compra</h6></br>
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="stockminimo" class="form-label">Cantidad</label>
                                            <input type="number" class="form-control" id="cantidad" name="cantidad" placeholder="" onchange="valorTotal()">
                                        </div>
                                    </div>
                                
                                    <div class="col-sm-8">    
                                        <div class="form-group">
                                            <label for="descripcion" class="form-label">Producto</label>
                                            <select class="form-control" id="producto" name="producto" required>
                                                <option value="0">Seleccionar</option>
                                                <?php foreach($productos as $p){?>
                                                    <option value="<?php echo $p['Pro_Id'];?>"><?php echo $p['Pro_Nombre'];?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="venta" class="form-label">Valor unitario</label>
                                            <input type="number" class="form-control" id="vunitario" name="vunitario" placeholder="" step="0.01" onchange="valorTotal()">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="venta" class="form-label">Valor total</label>
                                            <input type="number" class="form-control" id="vtotald" name="vtotald" placeholder="" step="0.01" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="button" class="btn btn-primary btn-sm" onclick="detalleC(event)">+</button>
                            <div class="table-responsive" style="overflow-x: auto;">
                            <table class="table table-striped" id="tablaDetalle" name="tablaDetalle">
                                <thead>
                                    <th>Id</th>
                                    <th>Cantidad</th>
                                    <th>Producto</th>
                                    <th>Valor Unitario</th>
                                    <th>Valor Total</th>
                                </thead>
                                <tbody></tbody>
                            </table>
                            </div>
                        </div>
                    </div>
                    <div class="text-start">
                        <button type="submit" class="btn btn-primary" data-bs-dismiss="modal">Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                    </div>
                    <input type="hidden" id="detalleCompra" name="detalleCompra">

                </div>
            </div>
        </div></form>
    </div>
    <div class="modal fade" id="editCompra" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <form action="<? echo base_url(); ?>compras/create" method="post"><div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">Editar compra</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                  
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="nombre" class="form-label">Fecha de compra</label>
                                <input type="date" class="form-control" id="editfecha" name="editfecha" aria-describedby="date" placeholder="">
                            </div>
                            <div class="form-group">
                                <label for="descripcion" class="form-label">Proveedor</label>
                                <select class="form-control" id="editproveedor" name="editproveedor" required>
                                    <option value="0">Seleccionar</option>
                                    <?php foreach($proveedores as $p){?>
                                        <option value="<?php echo $p['Prv_Id'];?>"><?php echo $p['Prv_Nombre'];?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="compra" class="form-label">Valor total</label>
                                <input type="number" class="form-control" id="editvtotal" name="editvtotal"  placeholder="" step="0.01">
                            </div>
                            <div class="form-group">
                                <label for="venta" class="form-label">Valor envío nacional</label>
                                <input type="number" class="form-control" id="editvnacional" name="editvnacional" placeholder="" step="0.01">
                            </div>
                            <div class="form-group">
                                <label for="venta" class="form-label">Valor envío internacional</label>
                                <input type="number" class="form-control" id="editvinternacional" name="editvinternacional"  placeholder="" step="0.01">
                            </div>
                            <div class="form-group">
                                <label for="stockminimo" class="form-label">Número de orden</label>
                                <input type="text" class="form-control" id="editnumeroorden" name="editnumeroorden" placeholder="">
                            </div>
                            <div class="form-group">
                                <label for="stockminimo" class="form-label">Tipo de pago</label>
                                <select class="form-control" id="edittipopago" name="edittipopago" required>
                                    <option value="0">Seleccionar</option>
                                    <?php foreach($tipopagoi as $t){?>
                                        <option value="<?php echo $t['Tpi_Id'];?>"><?php echo $t['Tpi_Nombre'];?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <h6>Detalle de la compra</h6></br>
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="stockminimo" class="form-label">Cantidad</label>
                                            <input type="number" class="form-control" id="editcantidad" name="editcantidad" placeholder="" onchange="valorTotal()">
                                        </div>
                                    </div>
                                
                                    <div class="col-sm-8">    
                                        <div class="form-group">
                                            <label for="descripcion" class="form-label">Producto</label>
                                            <select class="form-control" id="editproducto" name="editproducto" required>
                                                <option value="0">Seleccionar</option>
                                                <?php foreach($productos as $p){?>
                                                    <option value="<?php echo $p['Pro_Id'];?>"><?php echo $p['Pro_Nombre'];?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="venta" class="form-label">Valor unitario</label>
                                            <input type="number" class="form-control" id="editvunitario" name="editvunitario" placeholder="" step="0.01" onchange="valorTotal()">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="venta" class="form-label">Valor total</label>
                                            <input type="number" class="form-control" id="editvtotald" name="editvtotald" placeholder="" step="0.01" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="button" class="btn btn-primary btn-sm" onclick="detalleC()">+</button>
                            <table class="table table-striped" id="edittablaDetalle" name="edittablaDetalle">
                                <thead>
                                    <th>Id</th>
                                    <th>Cantidad</th>
                                    <th>Producto</th>
                                    <th>Valor Unitario</th>
                                    <th>Valor Total</th>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                    <input type="hidden" id='Com_Id' name="Com_Id">
                    <div class="text-start">
                        <button type="submit" class="btn btn-primary" data-bs-dismiss="modal">Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                    </div>
                    <input type="hidden" id="detalleCompra" name="detalleCompra">

                </div>
            </div>
        </div></form>
    </div>
    <!-- Modal: Recepción de Productos -->
<div class="modal fade" id="modalRecepcion" tabindex="-1" aria-labelledby="modalRecepcionLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <form action="<? echo base_url(); ?>/compras/registrarRecepcion" method="post">
            <div class="modal-content">
                <!-- Header -->
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="modalRecepcionLabel">Registrar Recepción de Productos</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>

                <!-- Body -->
                <div class="modal-body">
                    <div class="row g-3">
                        <!-- ID de Compra -->
                        <div class="col-md-6">
                            <label for="compra_id" class="form-label">ID de la Compra</label>
                            <input type="text" class="form-control" id="compra_id" name="compra_id" value="" readonly>
                        </div>
                        
                        <!-- Producto -->
                        <div class="col-md-6">
                            <label for="producto_id" class="form-label">Producto</label>
                            <select class="form-control" id="producto" name="producto" required>
                                <option value="0">Seleccionar</option>
                                <?php foreach($productos as $p){?>
                                    <option value="<?php echo $p['Pro_Id'];?>"><?php echo $p['Pro_Nombre'];?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <!-- Cantidad Recibida -->
                        <div class="col-md-6">
                            <label for="cantidad" class="form-label">Cantidad Recibida</label>
                            <input type="number" class="form-control" id="cantidad" name="cantidad" placeholder="Ingrese la cantidad recibida" min="1" required>
                        </div>

                        <!-- Fecha de Recepción -->
                        <div class="col-md-6">
                            <label for="fecha" class="form-label">Fecha de Recepción</label>
                            <input type="date" class="form-control" id="fecha" name="fecha" value="<?= date('Y-m-d') ?>" required>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Guardar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                </div>
            </div>
        </form>
    </div>
</div>

    <style>
        .modal-open .container-fluid,
.modal-open .container {
  -webkit-filter: blur(2px);
  -moz-filter: blur(2px);
  -o-filter: blur(2px);
  -ms-filter: blur(2px);
  filter: blur(2px);
}
    </style>