<?php
namespace App\Models;
use CodeIgniter\Model;
class VentasDetalleModel extends Model {
    protected $table = 'VentasDetalle';
    protected $primaryKey = 'Ved_Id';

    // Campos permitidos para operaciones de insercin o actualizacin
    protected $allowedFields = [
        'Ven_Id', 
        'Ved_Cantidad', 
        'Ved_ValorUnitario', 
        'Ved_ValorTotal', 
        'Ved_Descuento', 
        'Ved_Observacion',
        'Pro_Id',
        'Ved_ValorUnitario_Real'
    ];

    protected $useTimestamps = false; // Si no tienes campos created_at/updated_at, esto queda en false
    protected $returnType    = 'array'; // Devuelve resultados como array

    // Validaciones (opcional)
    protected $validationRules = [
        'Ven_Id'           => 'required|integer',
        'Ved_Cantidad'     => 'required|integer',
        'Ved_ValorUnitario'=> 'required|decimal',
        'Ved_ValorTotal'   => 'required|decimal',
        'Ved_Descuento'    => 'permit_empty|decimal',
        'Ved_Observacion'  => 'permit_empty|string'
    ];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    // CRUD Methods
    public function getAll()
    {
        return $this->findAll();
    }

    public function getById($id)
    {
        return $this->find($id);
    }

    public function create($data)
    {
        return $this->insert($data);
    }

    public function updateById($id, $data)
    {
        return $this->update($id, $data);
    }

    public function deleteById($id)
    {
        return $this->delete($id);
    }
}
?>
