<?php

namespace App\Models;

use CodeIgniter\Model;

class DashboardModel extends Model
{
    protected $db;

    public function __construct()
    {
        $this->db = \Config\Database::connect();
    }

    public function getTotalVentas()
    {
        return $this->db->table('VentasCabecera')
            ->selectSum('Ven_ValorTotal', 'total')
            ->where('MONTH(Ven_FechaVenta)', date('m'))
            ->where('YEAR(Ven_FechaVenta)', date('Y'))
            ->get()
            ->getRow()
            ->total ?? 0;
    }

    public function getTotalCompras()
    {
        return $this->db->table('ComprasCabecera')
            ->selectSum('Com_ValorTotal', 'total')
            ->where('MONTH(Com_FechaCompra)', date('m'))
            ->where('YEAR(Com_FechaCompra)', date('Y'))
            ->get()
            ->getRow()
            ->total ?? 0;
    }

    public function getStockTotal()
    {
        return $this->db->table('Inventario')
            ->selectSum('Inv_Cantidad', 'stock')
            ->get()
            ->getRow()
            ->stock ?? 0;
    }

    public function getProductosCriticos()
    {
        return $this->db->table('Productos')
            ->where('Pro_Stock < Pro_StockMinimo')
            ->countAllResults();
    }

    public function getMargenGanancia()
    {
        $ventas = $this->getTotalVentas();
        $compras = $this->getTotalCompras();

        if ($compras > 0) {
            return ($ventas - $compras) / $compras;
        }

        return 0;
    }

    public function getProductoMasVendido()
    {
        return $this->db->table('VentasDetalle vd')
            ->select('p.Pro_Nombre as nombre, SUM(vd.Ved_Cantidad) as cantidad')
            ->join('Productos p', 'vd.Pro_Id = p.Pro_Id')
            ->groupBy('vd.Pro_Id')
            ->orderBy('cantidad', 'DESC')
            ->limit(1)
            ->get()
            ->getRowArray() ?? ['nombre' => 'N/A', 'cantidad' => 0];
    }
}
