<?php

namespace App\Controllers;
use CodeIgniter\RESTful\ResourceController;
use App\Models\ProveedoresModel;
use CodeIgniter\Controller;

class Proveedores extends BaseController {

    protected $proveedoresModel;

    public function __construct() {
        $this->proveedoresModel = new ProveedoresModel();
    }

    public function index() {
        $data['proveedores'] = $this->proveedoresModel->findAll();
    
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("proveedores/list", $data);
        echo view("layouts/footer");
        echo view("proveedores/scripts");
    }


    public function view($id) {
        $data['proveedor'] = $this->proveedoresModel->find($id);
        if (empty($data['proveedor'])) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Proveedor no encontrado: ' . $id);
        }
        echo view('proveedores/view', $data);
    }

    public function create()
    {
        helper('form');
        $data = [];

        if ($this->request->getMethod() === 'post' && $this->validate([
            'nombre' => 'required',
        ])) {
            $saveData = [
                'Prv_Nombre' => $this->request->getPost('nombre'),
                'Prv_Telefono' => $this->request->getPost('telefono'),
                'Prv_CorreoElectronico' => $this->request->getPost('email'),
                'Prv_Url' => $this->request->getPost('url'),
                // Añadir otros campos según sea necesario
            ];

            if ($this->proveedoresModel->save($saveData)) {
                return redirect()->to('/proveedores');
            } else {
                $data['error'] = 'Error al guardar los datos.';
            }
        }

        echo view('proveedores/create', $data);
    }

    public function edit() {
        $id=$this->request->getPost('editid');
        $data['proveedor'] = $this->proveedoresModel->find($id);
        if (empty($data['proveedor'])) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Proveedor no encontrado: ' . $id);
        }

        helper('form');

        if ($this->request->getMethod() === 'post' && $this->validate([
                'editnombre' => 'required',
            ])) {
            $this->proveedoresModel->update($id, [
                'Prv_Nombre' => $this->request->getPost('editnombre'),
                'Prv_Telefono' => $this->request->getPost('edittelefono'),
                'Prv_CorreoElectronico' => $this->request->getPost('editemail'),
                'Prv_Url' => $this->request->getPost('editurl'),
                // Añadir otros campos según sea necesario
            ]);
            return redirect()->to('/proveedores');
        } else {
            echo view('proveedores', $data);
        }
    }

    public function delete($id) {
        $this->proveedoresModel->delete($id);
        return redirect()->to('/proveedores');
    }
}
