<?php
namespace App\Controllers;
use CodeIgniter\RESTful\ResourceController;
use App\Models\ProductosModel;
use CodeIgniter\Controller;
use App\Models\HistorialPreciosModel;

class Productos extends BaseController {

    public function __construct() {
        $this->productosModel = new ProductosModel();
    }

    public function index() {
        $data['productos'] = $this->productosModel->findAll();
    
        echo view("layouts/header");
        echo view("layouts/aside");
        echo view("productos/list", $data);
        echo view("layouts/footer");
        echo view("productos/scripts");
    }

    public function view($id) {
        $data['producto'] = $this->ProductosModel->get_product($id);
        if (empty($data['producto'])) {
            show_404();
        }
        $this->load->view('productos/view', $data);
    }

    public function create()
    {
        helper('form');
        $data = [];

        if ($this->request->getMethod() === 'post' && $this->validate([
            'nombre' => 'required',
        ])) {
            $saveData = [
                'Pro_Nombre' => $this->request->getPost('nombre'),
                'Pro_Descripcion' => $this->request->getPost('descripcion'),
                'Pro_PrecioCompra' => $this->request->getPost('compra'),
                'Pro_PrecioVenta' => $this->request->getPost('venta'),
                'Pro_StockMinimo' => $this->request->getPost('stockminimo'),
                // Añadir otros campos según sea necesario
            ];

            if ($this->productosModel->save($saveData)) {
                return redirect()->to('/productos');
            } else {
                $data['error'] = 'Error al guardar los datos.';
            }
        }

        return redirect()->to('/productos');
    }

    public function edit()
    {
        $id = $this->request->getPost('editid');
        $data['productos'] = $this->productosModel->find($id);
    
        if (empty($data['productos'])) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Producto no encontrado: ' . $id);
        }
    
        helper('form');
    
        if ($this->request->getMethod() === 'post' && $this->validate([
            'editnombre' => 'required',
        ])) {
            $this->productosModel->update($id, [
                'Pro_Nombre' => $this->request->getPost('editnombre'),
                'Pro_Descripcion' => $this->request->getPost('editdescripcion'),
                'Pro_PrecioCompra' => $this->request->getPost('editcompra'),
                'Pro_PrecioVenta' => $this->request->getPost('editventa'),
                'Pro_StockMinimo' => $this->request->getPost('editstockminimo'),
            ]);
            return redirect()->to('/productos');
        } else {
            echo view('productos/edit', $data); // Asegúrate de que la vista se llama correctamente
        }
    }

    public function delete($id) {
        $this->ProductosModel->delete_product($id);
        redirect('productos');
    }
    public function obtenerPrecioProducto($proId)
    {
        $historialModel = new HistorialPreciosModel();
        
        // Obtener el precio más reciente del producto
        $precio = $historialModel
            ->where('Pro_Id', $proId)
            ->orderBy('His_FechaCambio', 'DESC')
            ->first();

        if ($precio) {
            return $this->response->setJSON($precio);
        }

        return $this->response->setJSON(['error' => 'Producto no encontrado'], 404);
    }

}
?>
