<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Dashboard::index');

$routes->get('proveedores', 'Proveedores::index');
$routes->post('proveedores/create', 'Proveedores::create');
$routes->post('proveedores/edit', 'Proveedores::edit');

$routes->get('productos', 'Productos::index');
$routes->post('productos/edit', 'Productos::edit');
$routes->post('productos/create', 'Productos::create');
$routes->get('Productos/obtenerPrecioProducto/(:num)', 'Productos::obtenerPrecioProducto/$1');


$routes->get('clientes', 'Clientes::index');
$routes->post('clientes/create', 'Clientes::create');
$routes->post('clientes/edit', 'Clientes::edit');
$routes->post('clientes/createhijo', 'Clientes::createHijo');
$routes->post('clientes/edithijo', 'Clientes::editHijo');
$routes->post('clientes/hijosCliente', 'Clientes::hijosCliente');
$routes->get('clientes/hijosCliente', 'Clientes::hijosCliente');

$routes->get('compras', 'Compras::index');
$routes->post('compras/create', 'Compras::create');
$routes->post('compras/registrarRecepcion', 'Compras::registrarRecepcion');

$routes->get('ventas', 'Ventas::index');
$routes->post('ventas/create', 'Ventas::create');

$routes->get('/dashboard', 'Dashboard::index');

$routes->get('/inventario', 'InventarioDashboard::index');

$routes->get('/reporteVentasProducto', 'Reportes::ventasPorProducto');
$routes->get('/reporteVentasCliente', 'Reportes::ventasPorCliente');
$routes->get('/reporteAlertasCliente', 'Reportes::alertarClientes');
$routes->get('/reporteEstadisticas', 'Estadisticas::index');

$routes->post('whatsapp/send', 'Whatsapp::send');

$routes->post('/', 'Login::index');



